// shorten().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_LF.h"


// Implementation.

#include "cl_LF_impl.h"
#include "cl_DS.h"
#include "cl_F.h"

cl_LF shorten (const cl_LF& x, uintC len)
{
      // x = 0.0 braucht nicht abgefangen zu werden, da bei Mantisse 0 dann
      // sowieso abgerundet wird, die Mantisse also 0 bleibt.
      var Lfloat y = allocate_lfloat(len,TheLfloat(x)->expo,TheLfloat(x)->sign); // neues LF
      { var uintC oldlen = TheLfloat(x)->len; // alte Lnge, > len
        // Mantisse von x nach y kopieren:
        copy_loop_up(&TheLfloat(x)->data[0],&TheLfloat(y)->data[0],len);
        // Entscheiden, ob auf- oder abrunden:
        var uintD* ptr = &TheLfloat(x)->data[len];
        if ( ((sintD)ptr[0] >= 0) // nchstes Bit eine 0 -> abrunden
             || ( ((ptr[0] & ((uintD)bit(intDsize-1)-1)) ==0) // eine 1 und alles weitere Nullen?
                  && !test_loop_up(&ptr[1],oldlen-len-1)
                  // round-to-even
                  && ((ptr[-1] & bit(0)) ==0)
           )    )
          // abrunden
          {}
          else
          // aufrunden
          { if ( inc_loop_down(&TheLfloat(y)->data[len],len) )
              // bertrag durch Aufrunden
              { TheLfloat(y)->data[0] = bit(intDsize-1); // Mantisse := 10...0
                // Exponent erhhen:
                if (++(TheLfloat(y)->expo) == LF_exp_high+1) { cl_error_floating_point_overflow(); }
          }   }
      }
      return y;
}
