// cos().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"
#include "cl_integer.h"

cl_R cos (const cl_R& x)
{
// x rational -> bei x=0 1 als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   (q,r) := (round x (float pi x)), so da |r|<=pi/2.
//   e := Exponent aus (decode-float r), d := (float-digits r)
//   Bei r=0.0 oder e<=-d/2 liefere 1.0
//     (denn bei e<=-d/2 ist r^2/2 < 2^(-d)/2 = 2^(-d-1), also
//     1 >= cos(r) > 1-r^2/2 > 1-2^(-d-1),
//     also ist cos(r), auf d Bits gerundet, gleich 1.0).
//   Sonst s := r/2 = (scale-float r -1),
//     (sin(s)/s)^2 errechnen, cos(r) = 1-r*s*(sin(s)/s)^2 errechnen.
//   Falls q ungerade: Vorzeichenwechsel.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,0)) // x=0 -> 1 als Ergebnis
			return 1;
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	// Rechengenauigkeit erhhen und durch pi dividieren:
	var cl_F_div_t q_r = cl_round_pi(cl_F_extendsqrt(xx));
	var cl_I& q = q_r.quotient;
	var cl_F& r = q_r.remainder;
	var cl_F cos_r;
	if (zerop(r) || (float_exponent(r) <= (-(sintL)float_digits(r))>>1))
		cos_r = cl_float(1,xx); // (cos r) = 1.0
	else {
		var cl_F s = scale_float(r,-1); // s := r/2
		cos_r = cl_float(1 - r * s * sinx(s),xx);
	}
	if (oddp(q))
		return - cos_r; // q ungerade -> mal -1
	else
		return cos_r;
}
