// cl_cos_sin().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"
#include "cl_integer.h"
#include "cl_I.h"

cl_cos_sin_t cl_cos_sin (const cl_R& x)
{
// Methode:
// x rational -> bei x=0 (1,0) als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   (q,r) := (round x (float pi/2 x)), so da |r|<=pi/4.
//   y:=(sin(r)/r)^2 errechnen.
//   (cos r) berechnen:
//     e := Exponent aus (decode-float r), d := (float-digits r)
//     Bei r=0.0 oder e<=-d/2 liefere 1.0
//       (denn bei e<=-d/2 ist r^2/2 < 2^(-d)/2 = 2^(-d-1), also
//       1 >= cos(r) > 1-r^2/2 > 1-2^(-d-1),
//       also ist cos(r), auf d Bits gerundet, gleich 1.0).
//     Sonst sqrt(1-r^2*y).
//   (sin r) berechnen: r*sqrt(y).
//   Genauigkeit wieder verringern.
//   Falls q = 0 mod 4: ((cos r), (sin r))
//   Falls q = 1 mod 4: ((- (sin r)), (cos r))
//   Falls q = 2 mod 4: ((- (cos r)), (- (sin r)))
//   Falls q = 3 mod 4: ((sin r), (- (cos r)))

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,0)) // x=0 -> (1,0) als Ergebnis
			return cl_cos_sin_t(1,0);
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	// Rechengenauigkeit erhhen und durch pi/2 dividieren:
	var cl_F_div_t q_r = cl_round_pi2(cl_F_extendsqrt(xx));
	var cl_I& q = q_r.quotient;
	var cl_F& r = q_r.remainder;
	var cl_F y = sinx(r); // y := (sin(r)/r)^2
	// erste Komponente cos(r) berechnen:
	var cl_F cos_r;
	if (zerop(r) || (float_exponent(r) <= (-(sintL)float_digits(r))>>1))
		cos_r = cl_float(1,xx); // (cos r) = 1.0
	else
		cos_r = cl_float(sqrt(1 - r*r*y),xx); // sqrt(1-r^2*y)
	// zweite Komponente sin(r) berechnen:
	var cl_F sin_r = cl_float(r*sqrt(y),xx);
	// evtl. Vorzeichenwechsel oder Vertauschen:
	switch (FN_to_L(logand(q,3))) { // q mod 4
		case 0: return cl_cos_sin_t(cos_r,sin_r);
		case 1: return cl_cos_sin_t(-sin_r,cos_r);
		case 2: return cl_cos_sin_t(-cos_r,-sin_r);
		case 3: return cl_cos_sin_t(sin_r,-cos_r);
		default: NOTREACHED
	}
}
