// sin().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"
#include "cl_integer.h"

cl_R sin (const cl_R& x)
{
// Methode:
// x rational -> bei x=0 0 als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   (q,r) := (round x (float pi x)), so da |r|<=pi/2.
//   (sin(r)/r)^2 errechnen, Wurzel ziehen, mit r multiplizieren
//   und - falls q ungerade - Vorzeichenwechsel.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,0)) // x=0 -> 0 als Ergebnis
			return 0;
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	// Rechengenauigkeit erhhen und durch pi dividieren:
	var cl_F_div_t q_r = cl_round_pi(cl_F_extendsqrt(xx));
	var cl_I& q = q_r.quotient;
	var cl_F& r = q_r.remainder;
	// Wurzel aus (sin(r)/r)^2 mit r multiplizieren und wieder runden:
	var cl_F z = cl_float(sqrt(sinx(r))*r,xx);
	if (oddp(q))
		return -z; // q ungerade -> mal -1
	else
		return z;
}
