// Word level random number generator.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_random.h"


// Implementation.

#include "cl_DS.h"
#include "cl_low.h"

// Zufallszahlengenerator nach [Knuth: The Art of Computer Programming, Vol. II,
// Seminumerical Algorithms, 3.3.4., Table 1, Line 30], nach C. Haynes:
// X eine 64-Bit-Zahl. Iteration X := (a*X+c) mod m
// mit m=2^64, a=6364136223846793005, c=1.

uint32 random32 (cl_random_state& randomstate)
{
	var uintD* seedMSDptr = &randomstate.seed[0];
	// Multiplikator a=6364136223846793005 = 0x5851F42D4C957F2D :
	var static uintD multiplier[64/intDsize] =
	  { D(0x58,0x51,0xF4,0x2D,) D(0x4C,0x95,0x7F,0x2D,) } ;
	var uintD product[128/intDsize]; // Produkt
	// multiplizieren:
	cl_mulu_2loop_down(&seedMSDptr[64/intDsize],64/intDsize,
			   &multiplier[64/intDsize],64/intDsize,
			   &product[128/intDsize]
			  );
	// letzte 64 Bits holen:
	var uint32 seed_hi = get_32_Dptr(&product[64/intDsize]);
	var uint32 seed_lo = get_32_Dptr(&product[96/intDsize]);
	seed_lo += 1; if (seed_lo==0) { seed_hi += 1; } // um 1 erhhen
	// seed neu fllen:
	set_32_Dptr(seedMSDptr,seed_hi); set_32_Dptr(&seedMSDptr[32/intDsize],seed_lo);
	// mittlere 32 Bits als Ergebnis:
	return highlow32(low16(seed_hi),high16(seed_lo));
}
