// cl_free_heap_number().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_number.h"


// Implementation.

#include "cl_malloc.h"
#include "cl_I.h"
#include "cl_RA.h"
#include "cl_FF.h"
#include "cl_DF.h"
#include "cl_LF.h"
#include "cl_C.h"

void cl_free_heap_number (cl_heap* pointer)
{
	// This is invoked when pointer->refcount gets decremented to 0.

	// I wish it could be possible to write this in a more object oriented
	// way without completely losing efficiency.
	switch (pointer->typetag) {
	case cl_typetag_bignum:
		(*(cl_bignum*)pointer).~cl_bignum();
		break;
	case cl_typetag_ratio:
		(*(cl_ratio*)pointer).~cl_ratio();
		break;
#if !defined(CL_WIDE_POINTERS)
	case cl_typetag_ffloat:
		(*(cl_ffloat*)pointer).~cl_ffloat();
		break;
#endif
	case cl_typetag_dfloat:
		(*(cl_dfloat*)pointer).~cl_dfloat();
		break;
	case cl_typetag_lfloat:
		(*(cl_lfloat*)pointer).~cl_lfloat();
		break;
	case cl_typetag_complex:
		(*(cl_complex*)pointer).~cl_complex();
		break;
	case cl_typetag_none:
	default: NOTREACHED
	}
	cl_free_hook(pointer);
}
