// Low level: multiplication.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_low.h"


// Implementation.

#ifdef NEED_VAR_mulu32_high
uint32 mulu32_high;
#endif

#ifdef NEED_FUNCTION_mulu32_
uint32 mulu32_high;
uint32 mulu32_ (uint32 x, uint32 y)
{
	var uint16 x1 = high16(x);
	var uint16 x0 = low16(x);
	var uint16 y1 = high16(y);
	var uint16 y0 = low16(y);
	var uint32 hi = mulu16(x1,y1); // obere Portion
	var uint32 lo = mulu16(x0,y0); // untere Portion
	{var uint32 mid = mulu16(x0,y1); // 1. mittlere Portion
	 hi += high16(mid); mid = highlow32_0(low16(mid));
	 lo += mid; if (lo < mid) { hi += 1; } // 64-Bit-Addition
        }
	{var uint32 mid = mulu16(x1,y0); // 2. mittlere Portion
	 hi += high16(mid); mid = highlow32_0(low16(mid));
	 lo += mid; if (lo < mid) { hi += 1; } // 64-Bit-Addition
	}
	mulu32_high = hi; return lo;
}
#endif
