// Extendable strings.

#ifndef _CL_PUSHSTRING_H
#define _CL_PUSHSTRING_H

#include "cl_number.h"
#include "cl_malloc.h"
#include "cl_string.h"

class pushstring {
protected:
	char * buffer;
	uintL alloc; // allocated size of buffer
	uintL index; // index into buffer, 0 <= index <= alloc
public:
// Constructor. When constructed, the string is empty.
	pushstring ();
// Destructor.
	~pushstring ();
// Forget the contents.
	reset ();
// Add a character at the end.
	void push (char);
// Get the contents as a string. Free it using cl_malloc_hook() when done.
	char* contents ();
};
inline pushstring::pushstring ()
{
	alloc = 20; // Must be > 0.
	buffer = (char *) cl_malloc_hook(alloc);
	index = 0;
}
inline pushstring::~pushstring ()
{
	cl_free_hook(buffer);
}
inline pushstring::reset ()
{
	index = 0;
}
inline char* pushstring::contents ()
{
	return cl_string(buffer,index);
}

#endif /* _CL_PUSHSTRING_H */
