#include "cl_number.h"
#include "cl_integer.h"
#include "cl_io.h"

#define ASSERT(expr)  \
  if (!(expr)) { 							\
	fprint(cl_stderr,"Assertion failed! File ");			\
	fprint(cl_stderr,__FILE__);					\
	fprint(cl_stderr,", line ");					\
	fprintdecimal(cl_stderr,__LINE__);				\
	fprint(cl_stderr,".\n");					\
	error = 1;							\
  }

int test_xgcd (void)
{
	int error = 0;
	{
		cl_I a = 77874422;
		cl_I b = 32223899;
		cl_I u;
		cl_I v;
		cl_I g = xgcd(a,b, &u,&v);
		ASSERT(g == 1);
		ASSERT(u == 23017069);
		ASSERT(v == -55624583);
	}
	{
		cl_I a = "974507656412513757857315037382926980395082974811562770185617915360";
		cl_I b = "-1539496810360685510909469177732386446833404488164283";
		cl_I u;
		cl_I v;
		cl_I g = xgcd(a,b, &u,&v);
		ASSERT(g == 1);
		ASSERT(g == a*u+b*v);
	}
	return error;
}
