// div2adic().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_2DS.h"


// Implementation.

#include "cl_2D.h"
#include "cl_DS.h"

extern void div2adic (uintC len, const uintD* a_LSDptr, const uintD* b_LSDptr, uintD* dest_LSDptr)
{
      var uintD b0inv = div2adic(1,lspref(b_LSDptr,0)); // b'
      copy_loop_lsp(a_LSDptr,dest_LSDptr,len); // d := a
      do { var uintD digit = lspref(dest_LSDptr,0); // nchstes d[j]
           digit = mul2adic(b0inv,digit);
           // digit = nchstes c[j]
           mulusub_loop_lsp(digit,b_LSDptr,dest_LSDptr,len); // d := d - b * c[j] * beta^j
           // Nun ist lspref(dest_LSDptr,0) = 0.
           lspref(dest_LSDptr,0) = digit; // c[j] ablegen
           lsshrink(dest_LSDptr); len--; // nchstes j
         }
         until (len==0);
}
