// factorial().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"

  // Methode:
  // n <= 10 -> Ergebnis (Fixnum) aus Tabelle
  // Sonst:
  //   Zweierpotenzen extra am Schlu durch einen Shift um
  //   ord2(n!) = sum(k>=1, floor(n/2^k) ) = n - logcount(n)  Bits.
  //   Fr k>=1 wird jede ungerade Zahl m im Intervall n/2^k < m <= n/2^(k-1)
  //   genau k mal gebraucht (als ungerader Anteil von m*2^0,...,m*2^(k-1) ).
  //   Zur Bestimmung des Produkts aller ungeraden Zahlen in einem Intervall
  //   a < m <= b verwenden wir eine rekursive Funktion, die nach Divide-and-
  //   Conquer das Produkt ber die Intervalle a < m <= c und c < m <= b
  //   (c := floor((a+b)/2)) bestimmt und beide zusammenmultipliziert. Dies
  //   vermeidet, da oft groe Zahlen mit ganz kleinen Zahlen multipliziert
  //   werden.

  // UP fr Fakultt:
  // Bilde das Produkt prod(a < i <= b, 2*i+1), wobei 0 <= a < b klein.
    static cl_I prod_ungerade (uintL a, uintL b)
      { var uintL diff = b-a; // Anzahl der Faktoren
        if (diff <= 4)
          // Produkt iterativ bilden
          { var cl_I faktor = L_to_FN(2*b+1); // 2*b+1 als letzter Faktor
            var cl_I produkt = faktor;
            var uintC count;
            dotimesC(count,diff-1,
              { faktor = faktor-2; // nchster Faktor
                produkt = faktor*produkt; // mit bisherigem Produkt multiplizieren
              });
            return produkt;
          }
          else
          // Produkt rekursiv bilden
          { var uintL c = floor(a+b,2); // c:=floor((a+b)/2)
            return prod_ungerade(a,c) * prod_ungerade(c,b); // zwei Teilprodukte
          }
      }

static cl_I fakul_table [] = {
        L_to_FN(1),
        L_to_FN(1UL),
        L_to_FN(1UL*2),
        #if (cl_value_len>=4)
        L_to_FN(1UL*2*3),
        #if (cl_value_len>=6)
        L_to_FN(1UL*2*3*4),
        #if (cl_value_len>=8)
        L_to_FN(1UL*2*3*4*5),
        #if (cl_value_len>=11)
        L_to_FN(1UL*2*3*4*5*6),
        #if (cl_value_len>=14)
        L_to_FN(1UL*2*3*4*5*6*7),
        #if (cl_value_len>=17)
        L_to_FN(1UL*2*3*4*5*6*7*8),
        #if (cl_value_len>=20)
        L_to_FN(1UL*2*3*4*5*6*7*8*9),
        #if (cl_value_len>=23)
        L_to_FN(1UL*2*3*4*5*6*7*8*9*10),
        #if (cl_value_len>=27)
        L_to_FN(1UL*2*3*4*5*6*7*8*9*10*11),
        #if (cl_value_len>=30)
        L_to_FN(1UL*2*3*4*5*6*7*8*9*10*11*12),
        #if (cl_value_len>=34)
        ...
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
        #endif
};

cl_I factorial (uintL n) // assume n >= 0 small
{
      if (n < sizeof(fakul_table)/sizeof(cl_I))
        { return fakul_table[n]; }
        else
        { var cl_I prod = 1; // bisheriges Produkt := 1
          var uintL k = 1;
          var uintL A = n;
          var uintL B = n; // obere Intervallgrenze floor(n/2^(k-1))
          loop
            { // 'A' enthlt floor(n/2^(k-1)).
              A = A >> 1; // untere Grenze floor(n/2^k)
              // 'A' enthlt floor(n/2^k).
              // Bilde Teilprodukt prod(A < i <= B & oddp(i), i)
              //       = prod(floor((A-1)/2) < i <= floor((B-1)/2), 2*i+1)
              // wobei B = floor(n/2^(k-1)), A = floor(n/2^k) = floor(B/2).
              { var uintL b = floor(B-1,2);
                if (b==0) break; // B=2 oder B=1 -> Produkt fertig
                var uintL a = floor(A-1,2);
                prod = expt_pos(prod_ungerade(a,b),k) * prod; // aufmultiplizieren
              }
              k = k+1;
              B = A;
            }
          return prod << (n - logcount(n));
        }
}
