// class cl_ht_from_integer.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I_hash.h"


// Implementation.

#include "cl_hash1.h"

static inline bool equal (const cl_I& x, const cl_I& y)
{ return (bool)cl_equal(x,y); }

typedef cl_htentry1<cl_I,cl_object> cl_htentry_from_integer;

typedef cl_hashtable_1<cl_I,cl_object> cl_hashtable_from_integer;

typedef _cl_hashtable_iterator<cl_htentry_from_integer> cl_hashtable_from_integer_iterator;

static void cl_hashtable_from_integer_destructor (cl_heap* pointer)
{
	(*(cl_hashtable_from_integer*)pointer).~cl_hashtable_from_integer();
}
AT_INITIALIZATION(ini_cl_hashtable_from_integer)
{ cl_register_typetag(cl_typetag_hashtable_from_integer,cl_hashtable_from_integer_destructor); }

// These are not inline, because they tend to duplicate a lot of template code.

cl_ht_from_integer::cl_ht_from_integer ()
{
	var cl_hashtable_from_integer* ht = new ((cl_hashtable_from_integer*) cl_malloc_hook(sizeof(cl_hashtable_from_integer))) cl_hashtable_from_integer ();
	ht->refcount = 1;
	ht->typetag = cl_typetag_hashtable_from_integer;
	pointer = ht;
}

cl_object * cl_ht_from_integer::get (const cl_I& x) const
{
	return ((cl_hashtable_from_integer*)pointer)->get(x);
}

void cl_ht_from_integer::put (const cl_I& x, const cl_object& y) const
{
	((cl_hashtable_from_integer*)pointer)->put(x,y);
}



