// cl_ln2().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

#include "cl_lfloat.h"
#include "cl_LF.h"
#include "cl_I.h"

cl_LF cl_ln2 (uintC len)
{
	var uintC oldlen = TheLfloat(cl_LF_ln2)->len; // vorhandene Lnge
	if (len < oldlen)
		return shorten(cl_LF_ln2,len);
	if (len == oldlen)
		return cl_LF_ln2;

	// TheLfloat(cl_LF_ln2)->len um mindestens einen konstanten Faktor
	// > 1 wachsen lassen, damit es nicht zu hufig nachberechnet wird:
	var uintC newlen = len;
	oldlen += floor(oldlen,2); // oldlen * 3/2
	if (newlen < oldlen)
		newlen = oldlen;

	// gewnschte > vorhandene Lnge -> mu nachberechnen:
	var uintC actuallen = cl_LF_len_incsqrt(newlen); // Schutz-Digits
	var cl_LF ln2 = lnx(cl_I_to_LF(2,actuallen)); // (ln 2.0)
	cl_LF_ln2 = shorten(ln2,newlen); // verkrzen und abspeichern
	return (len < newlen ? shorten(cl_LF_ln2,len) : cl_LF_ln2);
}
