// sinh().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"

cl_R sinh (const cl_R& x)
{
// Methode:
// x rational -> bei x=0 0 als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   e := Exponent aus (decode-float x)
//   falls e<=0: (sinh(x)/x)^2 errechnen, Wurzel ziehen, mit x multiplizieren.
//   falls e>0: y:=exp(x) errechnen, (scale-float (- y (/ y)) -1) bilden.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,0)) // x=0 -> 0 als Ergebnis
			return 0;
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	if (float_exponent(xx) <= 0) { // Exponent e abtesten
		// e<=0
		// Rechengenauigkeit erhhen
		var cl_F xxx = cl_F_extendsqrt(xx);
		// Wurzel aus (sinh(x)/x)^2 mit x multiplizieren und wieder runden
		return cl_float(sqrt(sinhx(xxx))*xxx,xx);
	} else {
		// e>0 -> verwende exp(x)
		var cl_F y = exp(xx);
		return scale_float(y - recip(y), -1); // (/ (- y (/ y)) 2)
	}
}
