// class cl_symbol.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_symbol.h"


// Implementation.

#include "cl_hashuniq.h"

inline cl_string hashkey (const cl_symbol& sym)
{
	return (cl_string)sym;
}

// A symbol points to a string, so to convert cl_string -> cl_symbol, we just
// take the pointer and put it into a cl_symbol.
inline cl_symbol::cl_symbol (struct hashuniq * null, const cl_string& s)
	: cl_object (as_cl_private_thing(s)) { unused null; }

typedef cl_htuniqentry<cl_string,cl_symbol> cl_htentry_from_string_to_symbol;

typedef cl_hashtable_uniq<cl_string,cl_symbol> cl_hashtable_from_string_to_symbol;

typedef _cl_hashtable_iterator<cl_htentry_from_string_to_symbol> cl_hashtable_from_string_to_symbol_iterator;

static void cl_hashtable_from_string_to_symbol_destructor (cl_heap* pointer)
{
	(*(cl_hashtable_from_string_to_symbol*)pointer).~cl_hashtable_from_string_to_symbol();
}
AT_INITIALIZATION(ini_cl_hashtable_from_string_to_symbol)
{ cl_register_typetag(cl_typetag_hashtable_from_string_to_symbol,cl_hashtable_from_string_to_symbol_destructor); }

struct cl_ht_from_string_to_symbol : public cl_object {
	// Constructors.
	cl_ht_from_string_to_symbol ();
	cl_ht_from_string_to_symbol (const cl_ht_from_string_to_symbol&);
	// Assignment operators.
	cl_ht_from_string_to_symbol& operator= (const cl_ht_from_string_to_symbol&);
	// Iterator.
	cl_hashtable_from_string_to_symbol_iterator iterator () const
	{ return ((cl_hashtable_from_string_to_symbol*)pointer)->iterator(); }
	// Lookup.
	cl_symbol * get (const cl_string& s) const;
	// Store.
	void put (const cl_string& s) const;
};

// These are not inline, because they tend to duplicate a lot of template code.

cl_ht_from_string_to_symbol::cl_ht_from_string_to_symbol ()
{
	var cl_hashtable_from_string_to_symbol* ht = new ((cl_hashtable_from_string_to_symbol*) cl_malloc_hook(sizeof(cl_hashtable_from_string_to_symbol))) cl_hashtable_from_string_to_symbol ();
	ht->refcount = 1;
	ht->typetag = cl_typetag_hashtable_from_string_to_symbol;
	pointer = ht;
}

cl_symbol * cl_ht_from_string_to_symbol::get (const cl_string& s) const
{
	return ((cl_hashtable_from_string_to_symbol*)pointer)->get(s);
}

void cl_ht_from_string_to_symbol::put (const cl_string& s) const
{
	((cl_hashtable_from_string_to_symbol*)pointer)->put(s);
}

// The global symbol table.
static cl_ht_from_string_to_symbol symbol_table;

// Create or lookup a symbol from its name.
cl_symbol::cl_symbol (const cl_string& s)
{
	var cl_symbol * sym_in_table;
	sym_in_table = symbol_table.get(s);
	if (!sym_in_table) {
		symbol_table.put(s);
		sym_in_table = symbol_table.get(s);
		if (!sym_in_table)
			cl_abort();
	}
	var cl_heap* p = sym_in_table->heappointer;
	inc_pointer_refcount(p);
	pointer = p;
}
