// Number theoretic operations.

#ifndef _CL_NUMTHEORY_H
#define _CL_NUMTHEORY_H

#include "cl_number.h"
#include "cl_integer.h"

// jacobi(a,b) returns the Jacobi symbol
//                       (  a  )
//                       ( --- )
//                       (  b  )
// a, b must be integers, b > 0, b odd. The result is 0 iff gcd(a,b) > 1.
  extern int jacobi (sint32 a, sint32 b);
  extern int jacobi (const cl_I& a, const cl_I& b);

#endif /* _CL_NUMTHEORY_H */
