// Public random number operations.

#ifndef _CL_RANDOM_H
#define _CL_RANDOM_H

#include "cl_number.h"

class cl_random_state {
public:
	struct { uint32 hi; uint32 lo; } seed;
// Constructor:
	cl_random_state ();
};

// random32(randomstate) liefert eine neue Zufallszahl.
// > randomstate: ein Random-State, wird verndert
// < ergebnis: eine 32-Bit-Zufallszahl
extern uint32 random32 (cl_random_state& randomstate);

// random_I(randomstate,n) liefert zu einem Integer n>0 ein zuflliges
// Integer x mit 0 <= x < n.
// > randomstate: ein Random-State, wird verndert
extern cl_I random_I (cl_random_state& randomstate, const cl_I& n);

// random_F(randomstate,n) liefert zu einem Float n>0 ein zuflliges
// Float x mit 0 <= x < n.
// > randomstate: ein Random-State, wird verndert
extern cl_F random_F (cl_random_state& randomstate, const cl_F& n);

// random_R(randomstate,n) liefert zu einer reellen Zahl n>0 eine Zufallszahl
// x mit 0 <= x < n.
extern cl_R random_R (cl_random_state& randomstate, const cl_R& n);

// Ein globaler Zufallszahlengenerator.
extern cl_random_state cl_default_random_state;
// Das ist der Default-Generator.
inline uint32 random32 (void)
	{ return random32(cl_default_random_state); }
inline cl_I random_I (const cl_I& n)
	{ return random_I(cl_default_random_state,n); }
inline cl_F random_F (const cl_F& n)
	{ return random_F(cl_default_random_state,n); }
inline cl_R random_R (const cl_R& n)
	{ return random_R(cl_default_random_state,n); }

#endif /* _CL_RANDOM_H */
