// Digit sequence level random number generator.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_random_impl.h"


// Implementation.

#include "cl_random.h"
#include "cl_DS.h"
#include "cl_low.h"

void random_UDS (cl_random_state& randomstate, uintD* ptr, uintC len)
{
      var uintC count;
      dotimesC(count,floor(len,32/intDsize),
        { var uint32 next = random32(randomstate); // weitere 32/intDsize Digits besorgen
          set_32_Dptr(ptr,next); ptr = ptr mspop 32/intDsize;
        });
      len = len % (32/intDsize); // Anzahl noch fehlender Digits
      if (len>0)
        { var uint32 next = random32(randomstate); // weitere 32/intDsize Digits besorgen
          set_max32_Dptr(intDsize*len,ptr,next);
        }
}
