// cl_pi().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

#include "cl_lfloat.h"
#include "cl_LF.h"
#include "cl_I.h"

ALL_cl_LF_OPERATIONS_SAME_PRECISION()

cl_LF cl_pi (uintC len)
{
	var uintC oldlen = TheLfloat(cl_LF_pi)->len; // vorhandene Lnge
	if (len < oldlen)
		return shorten(cl_LF_pi,len);
	if (len == oldlen)
		return cl_LF_pi;

	// TheLfloat(cl_LF_pi)->len um mindestens einen konstanten Faktor
	// > 1 wachsen lassen, damit es nicht zu hufig nachberechnet wird:
	var uintC newlen = len;
	oldlen += floor(oldlen,2); // oldlen * 3/2
	if (newlen < oldlen)
		newlen = oldlen;

	// gewnschte > vorhandene Lnge -> mu nachberechnen:
	// Methode:
	// [Richard P. Brent: Fast multiple-precision evaluation of elementary
	//  functions. J. ACM 23(1976), 242-251.]
	// d=len, n:=16*d. Verwende Long-Floats mit 16*(d+1) Mantissenbits.
	// (let* ((a (coerce 1 'long-float)) ; 1
	//        (b (sqrt (scale-float a -1))) ; 2^-(1/2)
	//        (eps (scale-float a (- n))) ; 2^-n
	//        (t (scale-float a -2)) ; 1/4
	//        (x 0)
	//       )
	//   (loop
	//     (when (< (- a b) eps) (return))
	//     (let ((y a))
	//       (setq a (scale-float (+ a b) -1))
	//       (setq b (sqrt (* b y)))
	//       (setq t (- t (scale-float (expt (- a y) 2) x)))
	//     )
	//     (incf x)
	//   )
	//   (/ (expt a 2) t)
	// )
	var uintC actuallen = newlen + 1; // 1 Schutz-Digit
	var uintL uexp_limit = LF_exp_mid - intDsize*(uintL)newlen;
	// Ein Long-Float ist genau dann betragsmig <2^-n, wenn
	// sein Exponent < LF_exp_mid-n = uexp_limit ist.
	var cl_LF a = cl_I_to_LF(1,actuallen);
	var cl_LF b = sqrt(scale_float(a,-1));
	var uintL x = 0;
	var cl_LF t = scale_float(a,-2);
	until (TheLfloat(a-b)->expo < uexp_limit) {
		// |a-b| < 2^-n -> fertig
		var cl_LF new_a = scale_float(a+b,-1); // (a+b)/2
		b = sqrt(a*b);
		var cl_LF a_diff = new_a - a;
		t = t - scale_float(a_diff*a_diff,x);
		a = new_a;
		x++;
	}
	var cl_LF pi = (a*a)/t; // a^2/t
	cl_LF_pi = shorten(pi,newlen); // verkrzen und abspeichern
	return (len < newlen ? shorten(cl_LF_pi,len) : cl_LF_pi);
}
