// sqrt().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_lfloat.h"


// Implementation.

#include "cl_LF.h"
#include "cl_LF_impl.h"
#include "cl_F.h"
#include "cl_DS.h"

cl_LF sqrt (const cl_LF& x)
{
// Methode:
// x = 0.0 -> Ergebnis 0.0
// Ergebnis-Vorzeichen := positiv,
// Ergebnis-Exponent := ceiling(e/2),
// Ergebnis-Mantisse:
//   Erweitere die Mantisse (n Digits) um n+2 Nulldigits nach hinten.
//   Bei ungeradem e schiebe dies (oder nur die ersten n+1 Digits davon)
//     um 1 Bit nach rechts.
//   Bilde daraus die Ganzzahl-Wurzel, eine n+1-Digit-Zahl mit einer
//     fhrenden 1.
//   Runde das letzte Digit weg:
//     Bit 15 = 0 -> abrunden,
//     Bit 15 = 1, Rest =0 und Wurzel exakt -> round-to-even,
//     sonst aufrunden.
//   Bei rounding overflow Mantisse um 1 Bit nach rechts schieben
//     und Exponent incrementieren.
      var uintL uexp = TheLfloat(x)->expo;
      if (uexp==0) { return x; } // x=0.0 -> 0.0 als Ergebnis
      var uintC len = TheLfloat(x)->len;
      // Radikanden bilden:
      SAVE_NUM_STACK // num_stack retten
      var uintD* r_MSDptr;
      var uintD* r_LSDptr;
      var uintL r_len = 2*(uintL)len+2; // Lnge des Radikanden
      num_stack_alloc(r_len, r_MSDptr=,r_LSDptr=);
      uexp = uexp - LF_exp_mid + 1;
      if (uexp & bit(0))
        // Exponent gerade
        {var uintD* ptr =
           copy_loop_msp(arrayMSDptr(TheLfloat(x)->data,len),r_MSDptr,len); // n Digits kopieren
         clear_loop_msp(ptr,len+2); // n+2 Nulldigits anhngen
        }
        else
        // Exponent ungerade
        {var uintD carry_rechts = // n Digits kopieren und um 1 Bit rechts shiften
           shiftrightcopy_loop_msp(arrayMSDptr(TheLfloat(x)->data,len),r_MSDptr,len,1,0);
         var uintD* ptr = r_MSDptr mspop len;
         msprefnext(ptr) = carry_rechts; // bertrag und
         clear_loop_msp(ptr,len+1); // n+1 Nulldigits anhngen
        }
      uexp = (sintL)((sintL)uexp >> 1); // Exponent halbieren
      uexp = uexp + LF_exp_mid;
      // Ergebnis allozieren:
      var Lfloat y = allocate_lfloat(len,uexp,0);
      var uintD* y_mantMSDptr = arrayMSDptr(TheLfloat(y)->data,len);
      // Wurzel ziehen:
      var DS w;
      var cl_boolean exactp;
      UDS_sqrt(r_MSDptr,r_len,r_LSDptr, &w, exactp=);
      // w ist die Ganzzahl-Wurzel, eine n+1-Digit-Zahl.
      copy_loop_msp(w.MSDptr,y_mantMSDptr,len); // NUDS nach y kopieren
      // Runden:
      if ( ((sintD)lspref(w.LSDptr,0) >= 0) // nchstes Bit =0 -> abrunden
           || ( ((lspref(w.LSDptr,0) & ((uintD)bit(intDsize-1)-1)) ==0) // =1 und weitere Bits >0 oder Rest >0 -> aufrunden
                && exactp
                // round-to-even
                && ((lspref(w.LSDptr,1) & bit(0)) ==0)
         )    )
        // abrunden
        {}
        else
        // aufrunden
        { if ( inc_loop_lsp(y_mantMSDptr mspop len,len) )
            // bertrag durchs Aufrunden
            { mspref(y_mantMSDptr,0) = bit(intDsize-1); // Mantisse := 10...0
              (TheLfloat(y)->expo)++; // Exponenten incrementieren
        }   }
      return y;
}
