// 1 < m < 2^32, standard representation

static cl_MI int32_plus (cl_heap_modint_ring* R, const cl_MI& x, const cl_MI& y)
{
	if (!(x.ring == R)) cl_abort();
	if (!(y.ring == R)) cl_abort();
	var uint32 xr = I_to_UL(x.rep);
	var uint32 yr = I_to_UL(y.rep);
	var uint32 zr = xr + yr;
	var uint32 m = I_to_UL(R->modulus);
	if ((zr < xr) || (zr >= m)) { zr = zr - m; }
	return cl_MI(R, UL_to_I(zr));
}

static cl_MI int32_minus (cl_heap_modint_ring* R, const cl_MI& x, const cl_MI& y)
{
	if (!(x.ring == R)) cl_abort();
	if (!(y.ring == R)) cl_abort();
	var uint32 xr = I_to_UL(x.rep);
	var uint32 yr = I_to_UL(y.rep);
	var sint32 zr = (xr >= yr ? xr - yr : xr - yr + I_to_UL(R->modulus));
	return cl_MI(R, UL_to_I(zr));
}

static cl_MI int32_uminus (cl_heap_modint_ring* R, const cl_MI& x)
{
	if (!(x.ring == R)) cl_abort();
	var uint32 xr = I_to_UL(x.rep);
	var uint32 zr = (xr==0 ? 0 : I_to_UL(R->modulus)-xr);
	return cl_MI(R, UL_to_I(zr));
}

static cl_MI int32_mul (cl_heap_modint_ring* R, const cl_MI& x, const cl_MI& y)
{
	if (!(x.ring == R)) cl_abort();
	if (!(y.ring == R)) cl_abort();
	var uint32 xr = I_to_UL(x.rep);
	var uint32 yr = I_to_UL(y.rep);
	var uint32 zrhi;
	var uint32 zrlo;
	mulu32(xr,yr,zrhi=,zrlo=);
	var uint32 zr;
	divu_6432_3232(zrhi,zrlo,I_to_UL(R->modulus),,zr=);
	return cl_MI(R, UL_to_I(zr));
}

static cl_MI int32_square (cl_heap_modint_ring* R, const cl_MI& x)
{
	if (!(x.ring == R)) cl_abort();
	var uint32 xr = I_to_UL(x.rep);
	var uint32 zrhi;
	var uint32 zrlo;
	mulu32(xr,xr,zrhi=,zrlo=);
	var uint32 zr;
	divu_6432_3232(zrhi,zrlo,I_to_UL(R->modulus),,zr=);
	return cl_MI(R, UL_to_I(zr));
}

static cl_modint_addops int32_addops = {
	std_zero,
	int32_plus,
	int32_minus,
	int32_uminus
};
static cl_modint_mulops int32_mulops = {
	std_one,
	int32_mul,
	int32_square,
	std_recip,
	std_div,
	std_expt_pos,
	std_expt,
	std_reduce_modulo,
	std_canonhom,
	std_retract
};

class cl_heap_modint_ring_int32 : public cl_heap_modint_ring {
public:
	// Allocation.
	void* operator new (size_t size) { return cl_malloc_hook(size); }
	// Deallocation.
	void operator delete (void* ptr) { cl_free_hook(ptr); }
	// Constructor.
	cl_heap_modint_ring_int32 (const cl_I& m)
		: cl_heap_modint_ring (m, &std_setops, &int32_addops, &int32_mulops) {}
	// Virtual destructor.
	~cl_heap_modint_ring_int32 () {}
};
