// m > 0, m = 2^m1 - 1 (m1 > 1)

class cl_heap_modint_ring_pow2m1 : public cl_heap_modint_ring {
public:
	// Allocation.
	void* operator new (size_t size) { return cl_malloc_hook(size); }
	// Deallocation.
	void operator delete (void* ptr) { cl_free_hook(ptr); }
	// Constructor.
	cl_heap_modint_ring_pow2m1 (const cl_I& m, uintL m1); // m = 2^m1 - 1
	// Virtual destructor.
	~cl_heap_modint_ring_pow2m1 () {}
	// Additional information.
	uintL m1;
};

static inline cl_I pow2m1_reduce_modulo (cl_heap_modint_ring* _R, const cl_I& x)
{
	var cl_heap_modint_ring_pow2m1* R = (cl_heap_modint_ring_pow2m1*)_R;
	// Method:
	// If x>=0, split x into pieces of m1 bits and sum them up.
	//   x = x0 + 2^m1*x1 + 2^(2*m1)*x2 + ... ==>
	//   mod(x,m) = mod(x0+x1+x2+...,m).
	// If x<0, apply this to -1-x, and use mod(x,m) = m-1-mod(-1-x,m).
 {	Mutable(cl_I,x);
	var cl_boolean sign = minusp(x);
	if (sign) { x = lognot(x); }
	var const uintL m1 = R->m1;
	if (x >= R->modulus) {
		x = plus1(x); // avoid staying at x = m
		do {
			var uintL xlen = integer_length(x);
			var cl_I y = ldb(x,cl_byte(m1,0));
			for (var uintL i = m1; i < xlen; i += m1)
				y = y + ldb(x,cl_byte(m1,i));
			x = y;
		} while (x > R->modulus);
		x = minus1(x);
	}
	// Now 0 <= x < m.
	if (sign) { x = R->modulus - 1 - x; }
	return x;
}}

static cl_MI pow2m1_canonhom (cl_heap_modint_ring* R, const cl_I& x)
{
	return cl_MI(R, pow2m1_reduce_modulo(R,x));
}

static cl_MI pow2m1_mul (cl_heap_modint_ring* _R, const cl_MI& x, const cl_MI& y)
{
	var cl_heap_modint_ring_pow2m1* R = (cl_heap_modint_ring_pow2m1*)_R;
	if (!(x.ring == R)) cl_abort();
	if (!(y.ring == R)) cl_abort();
	var const uintL m1 = R->m1;
	var cl_I zr = x.rep * y.rep;
	zr = ldb(zr,cl_byte(m1,m1)) + ldb(zr,cl_byte(m1,0));
	return cl_MI(R, (zr >= R->modulus ? zr - R->modulus : zr));
}

static cl_MI pow2m1_square (cl_heap_modint_ring* _R, const cl_MI& x)
{
	var cl_heap_modint_ring_pow2m1* R = (cl_heap_modint_ring_pow2m1*)_R;
	if (!(x.ring == R)) cl_abort();
	var const uintL m1 = R->m1;
	var cl_I zr = square(x.rep);
	zr = ldb(zr,cl_byte(m1,m1)) + ldb(zr,cl_byte(m1,0));
	return cl_MI(R, (zr >= R->modulus ? zr - R->modulus : zr));
}

#define pow2m1_addops std_addops
static cl_modint_mulops pow2m1_mulops = {
	std_one,
	pow2m1_mul,
	pow2m1_square,
	std_recip,
	std_div,
	std_expt_pos,
	std_expt,
	pow2m1_reduce_modulo,
	pow2m1_canonhom,
	std_retract
};

// Constructor.
inline cl_heap_modint_ring_pow2m1::cl_heap_modint_ring_pow2m1 (const cl_I& m, uintL _m1)
	: cl_heap_modint_ring (m, &std_setops, &pow2m1_addops, &pow2m1_mulops), m1 (_m1) {}
