// cl_cosh_sinh().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"

cl_cosh_sinh_t cl_cosh_sinh (const cl_R& x)
{
// Methode:
// x rational -> bei x=0 (1,0) als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   e := Exponent aus (decode-float x), d := (float-digits x)
//   falls x=0.0 oder e<=(1-d)/2 liefere (1.0,x)
//     (denn bei e<=(1-d)/2 ist
//      1 <= sinh(x)/x < cosh(x) = 1+x^2/2+... < 1+2^(-d),
//      also ist cosh(x), auf d Bits gerundet, gleich 1.0
//      und sinh(x), auf d Bits gerundet, gleich x).
//   falls e<=0:
//     y:=(sinh(x)/x)^2 errechnen,
//     cosh(x) = sqrt(1+x^2*y) und sinh(x) = x*sqrt(y) errechnen.
//   falls e>0: y:=exp(x) errechnen,
//     (scale-float (+ y (/ y)) -1) und (scale-float (- y (/ y)) -1) bilden.
//   Genauigkeit wieder verringern.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,0)) // x=0 -> (1,0) als Ergebnis
			return cl_cosh_sinh_t(1,0);
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	var sintL e = float_exponent(xx);
	if (e <= 0) { // Exponent e abtesten
		// e<=0
		if (zerop(xx) || (e <= (1-(sintL)float_digits(xx))>>1))
			// e <= (1-d)/2 <==> e <= -ceiling((d-1)/2)
			return cl_cosh_sinh_t(cl_float(1,xx),xx);
		// Rechengenauigkeit erhhen
		var cl_F xxx = cl_F_extendsqrt(xx);
		var cl_F xxx2 = xxx*xxx;
		var cl_F y = scale_float(xxx,-1);
		return cl_cosh_sinh_t(
			cl_float(sqrt(1+xxx*xxx*y),xx), // sqrt(1+x^2*y)
			cl_float(x*sqrt(y))
		       );
	} else {
		// e>0 -> verwende exp(x)
		var cl_F y = exp(xx);
		var cl_F y_inv = recip(y);
		return cl_cosh_sinh_t(
			scale_float(y+y_inv,-1),
			scale_float(y-y_inv,-1)
		       );
	}
}
