// ln().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"
#include "cl_SF.h"
#include "cl_RA.h"
#include "cl_integer.h"

cl_R ln (const cl_R& x)
{
// Methode:
// x rational -> bei x=1 0 als Ergebnis, sonst x in Float umwandeln.
// x Float ->
//   d := (float-digits x),
//   Genauigkeit um sqrt(d)+max(integer-length(e)) Bits erhhen,
//   (m,e) := (decode-float x), so da 1/2 <= m < 1.
//   m<2/3 -> m:=2m, e:=e-1, so da 2/3 <= m <= 4/3.
//   ln(m) errechnen, ln(x)=ln(m)+e*ln(2) als Ergebnis.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (eq(x,1)) // x=1 -> 0 als Ergebnis
			return 0;
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	// Rechengenauigkeit erhhen und m,e,s bestimmen:
	var cl_decoded_float m_e_s = decode_float(cl_F_extendsqrtx(xx));
	var cl_F& m = m_e_s.mantissa;
	var cl_I& e = m_e_s.exponent;
	if (m < make_SF(0,0+SF_exp_mid,floor(bit(SF_mant_len+2),3))) { // Short-Float 2/3
		m = scale_float(m,1); // m verdoppeln
		e = minus1(e); // e decrementieren
	}
	return cl_float(lnx(m)+cl_float(e,m)*cl_ln2(m),xx); // ln(m)+e*ln(2)
}
