// cl_R internals, transcendental functions

#ifndef _CL_R_TRAN_H
#define _CL_R_TRAN_H

#include "cl_number.h"
#include "cl_real.h"
#include "cl_R.h"

// pi.
extern cl_SF cl_SF_pi;
extern cl_FF cl_FF_pi;
extern cl_DF cl_DF_pi;
extern cl_LF cl_LF_pi; // as long as it has ever been computed
extern cl_LF cl_pi (uintC len); // computes it even further

// atanhx(x) liefert zu einem Float x (betragsmig <1/2) atanh(x) als Float.
extern cl_F atanhx (const cl_F& x);

// atanx(x) liefert zu einem Float x (betragsmig <=1) atan(x) als Float.
extern cl_F atanx (const cl_F& x);

// sinx(x) liefert zu einem Float x (betragsmig <2) (sin(x)/x)^2 als Float.
extern cl_F sinx (const cl_F& x);

// sinhx(x) liefert zu einem Float x (betragsmig <2) (sinh(x)/x)^2 als Float.
extern cl_F sinhx (const cl_F& x);

// cl_round_pi(x) dividiert ein Float x mit Rest durch pi.
// Beide Werte von (round x (float pi x)).
extern cl_F_div_t cl_round_pi (const cl_F& x);

// cl_round_pi2(x) dividiert ein Float x mit Rest durch pi/2.
// Beide Werte von (round x (float pi/2 x)).
extern cl_F_div_t cl_round_pi2 (const cl_F& x);

// lnx(x) liefert zu einem Float x (>=1/2, <=2) ln(x) als Float.
extern cl_F lnx (const cl_F& x);
// Spezialfall: x Long-Float -> Ergebnis Long-Float
inline cl_LF lnx (const cl_LF& x) { return The(cl_LF)(lnx(The(cl_F)(x))); }

// ln(2).
extern cl_SF cl_SF_ln2;
extern cl_FF cl_FF_ln2;
extern cl_DF cl_DF_ln2;
extern cl_LF cl_LF_ln2; // as long as it has ever been computed
extern cl_LF cl_ln2 (uintC len); // computes it even further

// cl_ln2(y) liefert die Zahl ln(2) im selben Float-Format wie y.
// > y: ein Float
extern cl_F cl_ln2 (const cl_F& y);

// cl_ln2(y) liefert die Zahl ln(2) im Float-Format f.
// > f: eine Float-Format-Spezifikation
extern cl_F cl_ln2 (cl_float_format_t f);

// ln(10).
extern cl_SF cl_SF_ln10;
extern cl_FF cl_FF_ln10;
extern cl_DF cl_DF_ln10;
extern cl_LF cl_LF_ln10; // as long as it has ever been computed
extern cl_LF cl_ln10 (uintC len); // computes it even further

// cl_ln10(y) liefert die Zahl ln(10) im selben Float-Format wie y.
// > y: ein Float
extern cl_F cl_ln10 (const cl_F& y);

// cl_ln10(y) liefert die Zahl ln(10) im Float-Format f.
// > f: eine Float-Format-Spezifikation
extern cl_F cl_ln10 (cl_float_format_t f);

// expx(x) liefert zu einem Float x (betragsmig <1) exp(x) als Float.
extern cl_F expx (const cl_F& x);


#endif /* _CL_R_TRAN_H */
