// cl_symbol hashcode().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_symbol.h"


// Implementation.

#undef offsetof
#define offsetof(type,ident)  ((unsigned long)&(((type*)0)->ident))
#define offsetofa(type,ident)  offsetof(type,ident[0])

#define alignof(type)  offsetof(struct { char slot1; type slot2; }, slot2)

unsigned long hashcode (const cl_symbol& s)
{
	// Strings don't move in memory, so we can just take the address.
	const unsigned long string_alignment = alignof(cl_heap_string);
	return (unsigned long)(s.pointer)
	       / (string_alignment & -string_alignment); // divide by power of 2
}
