// Working with long-floats of the same size.

#ifndef _CL_LF_SAMESIZE_H
#define _CL_LF_SAMESIZE_H

// Include this file ONLY if all your cl_LF operations (+, -, *, /)
// ALWAYS get two operands of the same size.

// Ignore gcc warnings about "operator was used before it was declared inline".

#include "cl_LF.h"

inline cl_LF operator+ (const cl_LF& x, const cl_LF& y)
{
	return LF_LF_plus_LF(x,y);
}

inline cl_LF operator- (const cl_LF& x, const cl_LF& y)
{
	return LF_LF_minus_LF(x,y);
}

inline cl_LF operator* (const cl_LF& x, const cl_LF& y)
{
	return LF_LF_mul_LF(x,y);
}

inline cl_LF operator/ (const cl_LF& x, const cl_LF& y)
{
	return LF_LF_div_LF(x,y);
}

#endif /* _CL_LF_SAMESIZE_H */
