// CLN exported types and functions

#ifndef _CLN_H
#define _CLN_H

// Basic types and definitions.
#include "cl_config.h"
#include "cl_intparam.h"
#include "cl_types.h"
#include "cl_object.h"

// The numbers.
#include "cl_number.h"
#include "cl_real.h"
#include "cl_float.h"
#include "cl_sfloat.h"
#include "cl_ffloat.h"
#include "cl_dfloat.h"
#include "cl_lfloat.h"
#include "cl_rational.h"
#include "cl_integer.h"
#include "cl_complex.h"

// Miscellaneous.
#include "cl_random.h"
#include "cl_malloc.h"
#include "cl_abort.h"
#include "cl_io.h"
#include "cl_input.h"
#include "cl_output.h"
#include "cl_condition.h"

// Symbolic facilities.
#include "cl_string.h"
#include "cl_symbol.h"
#include "cl_proplist.h"

// Rings.
#include "cl_ring.h"

// Rings for number theory.
#include "cl_numtheory.h"
#include "cl_modinteger.h"

// Vectors.
#include "cl_V.h"
#if !defined(ITALK_CLN_BINDING)
#include "cl_GV.h"
#include "cl_GV_integer.h"
#include "cl_GV_rational.h"
#include "cl_GV_real.h"
#include "cl_GV_complex.h"
#include "cl_GV_modinteger.h"
#include "cl_SV.h"
#include "cl_SV_integer.h"
#include "cl_SV_rational.h"
#include "cl_SV_real.h"
#include "cl_SV_complex.h"
#include "cl_SV_ringelt.h"
#endif

// Polynomials.
#include "cl_univpoly.h"
#include "cl_univpoly_integer.h"
#include "cl_univpoly_rational.h"
#include "cl_univpoly_real.h"
#include "cl_univpoly_complex.h"
#include "cl_univpoly_modint.h"

// Environmental facilities.
#include "cl_timing.h"

#endif /* _CLN_H */

