// cl_make_heap_GV_N().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_GV_complex.h"


// Implementation.

#include "cl_abort.h"
#include "cl_offsetof.h"


static void cl_gvector_number_destructor (cl_heap* pointer)
{
#if (defined(__mips__) || defined(__mips64__)) && !defined(__GNUC__) // workaround SGI CC bug
	(*(cl_heap_GV_N*)pointer).~cl_heap_GV();
#else
	(*(cl_heap_GV_N*)pointer).~cl_heap_GV_N();
#endif
}
AT_INITIALIZATION(ini_cl_gvector_number)
{ cl_register_typetag(cl_typetag_gvector_number,cl_gvector_number_destructor); }


static inline cl_heap_GV_N * outcast (cl_GV_inner<cl_N>* vec)
{
	return (cl_heap_GV_N *)((char *) vec - offsetof(cl_heap_GV_N,v));
}
static inline const cl_heap_GV_N * outcast (const cl_GV_inner<cl_N>* vec)
{
	return (const cl_heap_GV_N *)((const char *) vec - offsetof(cl_heap_GV_N,v));
}


// Vectors of numbers.

struct cl_heap_GV_N_general : public cl_heap_GV_N {
	cl_N data[1];
	// Standard allocation disabled.
	void* operator new (size_t size) { unused size; cl_abort(); return NULL; }
	// Standard deallocation disabled.
	void operator delete (void* ptr) { unused ptr; cl_abort(); }
	// No default constructor.
	cl_heap_GV_N_general ();
};

static cl_N general_element (const cl_GV_inner<cl_N>* vec, uintL index)
{
	return ((const cl_heap_GV_N_general *) outcast(vec))->data[index];
}

static void general_set_element (cl_GV_inner<cl_N>* vec, uintL index, const cl_N& x)
{
	((cl_heap_GV_N_general *) outcast(vec))->data[index] = x;
}

static void general_do_delete (cl_GV_inner<cl_N>* vec)
{
	var cl_heap_GV_N_general* hv = (cl_heap_GV_N_general *) outcast(vec);
	var uintL len = hv->v.length();
	for (var uintL i = 0; i < len; i++)
		hv->data[i].~cl_N();
}

static cl_GV_vectorops<cl_N> general_vectorops = {
	general_element,
	general_set_element,
	general_do_delete
};

cl_heap_GV_N* cl_make_heap_GV_N (uintL len)
{
	var cl_heap_GV_N_general* hv = (cl_heap_GV_N_general*) cl_malloc_hook(offsetofa(cl_heap_GV_N_general,data)+sizeof(cl_N)*len);
	hv->refcount = 1;
	hv->typetag = cl_typetag_gvector_number;
	new (&hv->v) cl_GV_inner<cl_N> (len,&general_vectorops);
	for (var uintL i = 0; i < len; i++)
		init1(cl_N, hv->data[i]) ();
	return hv;
}

// An empty vector.
cl_GV_N cl_null_GV_N = cl_GV_N((uintL)0);
