// cl_make_heap_SV_N().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_SV_complex.h"


// Implementation.

#include "cl_abort.h"


static void cl_svector_number_destructor (cl_heap* pointer)
{
#if (defined(__mips__) || defined(__mips64__)) && !defined(__GNUC__) // workaround SGI CC bug
	(*(cl_heap_SV_N*)pointer).~cl_heap_SV();
#else
	(*(cl_heap_SV_N*)pointer).~cl_heap_SV_N();
#endif
}
AT_INITIALIZATION(ini_cl_svector_number)
{ cl_register_typetag(cl_typetag_svector_number,cl_svector_number_destructor); }

cl_heap_SV_N* cl_make_heap_SV_N_uninit (uintL len)
{
	var cl_heap_SV_N* hv = (cl_heap_SV_N*) cl_malloc_hook(sizeof(cl_heap_SV_N)+sizeof(cl_N)*len);
	hv->refcount = 1;
	hv->typetag = cl_typetag_svector_number;
	new (&hv->v) cl_SV_inner<cl_N> (len);
	// Have to fill hv->v[i] (0 <= i < len) yourself.
	return hv;
}

cl_heap_SV_N* cl_make_heap_SV_N (uintL len)
{
	var cl_heap_SV_N* hv = (cl_heap_SV_N*) cl_malloc_hook(sizeof(cl_heap_SV_N)+sizeof(cl_N)*len);
	hv->refcount = 1;
	hv->typetag = cl_typetag_svector_number;
	new (&hv->v) cl_SV_inner<cl_N> (len);
	for (var uintL i = 0; i < len; i++)
		init1(cl_N, hv->v[i]) (0);
	return hv;
}

// An empty vector.
cl_SV_N cl_null_SV_N = cl_SV_N((uintL)0);
