// cl_string debugging support.

// General includes.
#include "cl_sysdep.h"

// Specification.


// Implementation.

#include "cl_string.h"
#include "cl_io.h"
#include <ctype.h>

static void dprint (cl_heap* pointer)
{
	var const cl_string& obj = *(const cl_string*)&pointer;
	fprint(cl_stderr, "(cl_string) \"");
	var unsigned long l = obj.length();
	for (var unsigned long i = 0; i < l; i++) {
		var unsigned char c = obj[i];
		if (c >= 0x20) {
			if (c == '"' || c == '\\')
				fprintchar(cl_stderr, '\\');
			fprintchar(cl_stderr, c);
		} else
		switch (c) {
			case '\n': fprint(cl_stderr, "\\n"); break;
			case '\t': fprint(cl_stderr, "\\t"); break;
			case '\b': fprint(cl_stderr, "\\b"); break;
			case '\r': fprint(cl_stderr, "\\r"); break;
			case '\f': fprint(cl_stderr, "\\f"); break;
			case '\v': fprint(cl_stderr, "\\v"); break;
			default:
				static const char hexdigits[] = "0123456789abcdef";
				fprintchar(cl_stderr, '\\');
				fprintchar(cl_stderr, 'x');
				fprintchar(cl_stderr, hexdigits[(c>>4)&0x0f]);
				fprintchar(cl_stderr, hexdigits[c&0x0f]);
				break;
		}
	}
	fprint(cl_stderr, "\"");
}
AT_INITIALIZATION(dprint_string)
{ cl_register_typetag_printer(cl_typetag_string,dprint); }

// This dummy links in this module when <cl_string.h> requires it.
int cl_string_debug_module;
