// logcount().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"

  // Bits von x8 zhlen: (Input x8, Output x8)
  #define logcount_8()  \
    ( /* x8 besteht aus 8 1-Bit-Zhlern (0,1).        */\
      x8 = (x8 & 0x55U) + ((x8 & 0xAAU) >> 1),		\
      /* x8 besteht aus 4 2-Bit-Zhlern (0,1,2).      */\
      x8 = (x8 & 0x33U) + ((x8 & 0xCCU) >> 2),		\
      /* x8 besteht aus 2 4-Bit-Zhlern (0,1,2,3,4).  */\
      x8 = (x8 & 0x0FU) + (x8 >> 4)			\
      /* x8 besteht aus 1 8-Bit-Zhler (0,...,8).     */\
    )
  // Bits von x16 zhlen: (Input x16, Output x16)
  #define logcount_16()  \
    ( /* x16 besteht aus 16 1-Bit-Zhlern (0,1).      */\
      x16 = (x16 & 0x5555U) + ((x16 & 0xAAAAU) >> 1),	\
      /* x16 besteht aus 8 2-Bit-Zhlern (0,1,2).     */\
      x16 = (x16 & 0x3333U) + ((x16 & 0xCCCCU) >> 2),	\
      /* x16 besteht aus 4 4-Bit-Zhlern (0,1,2,3,4). */\
      x16 = (x16 & 0x0F0FU) + ((x16 & 0xF0F0U) >> 4),	\
      /* x16 besteht aus 2 8-Bit-Zhlern (0,...,8).   */\
      x16 = (x16 & 0x00FFU) + (x16 >> 8)		\
      /* x16 besteht aus 1 16-Bit-Zhler (0,...,16).  */\
    )
  // Bits von x32 zhlen: (Input x32, Output x32)
  #define logcount_32()  \
    ( /* x32 besteht aus 32 1-Bit-Zhlern (0,1).              */\
      x32 = (x32 & 0x55555555UL) + ((x32 & 0xAAAAAAAAUL) >> 1),	\
      /* x32 besteht aus 16 2-Bit-Zhlern (0,1,2).            */\
      x32 = (x32 & 0x33333333UL) + ((x32 & 0xCCCCCCCCUL) >> 2),	\
      /* x32 besteht aus 8 4-Bit-Zhlern (0,1,2,3,4).         */\
      x32 = high16(x32)+low16(x32),				\
      /* x32 besteht aus 4 4-Bit-Zhlern (0,...,8).           */\
      x32 = (x32 & 0x0F0FU) + ((x32 & 0xF0F0U) >> 4),		\
      /* x32 besteht aus 2 8-Bit-Zhlern (0,...,16).          */\
      x32 = (x32 & 0x00FFU) + (x32 >> 8)			\
      /* x32 besteht aus 1 16-Bit-Zhler (0,...,32).          */\
    )
  // Bits von x64 zhlen: (Input x64, Output x64)
  #define logcount_64()  \
    ( /* x64 besteht aus 64 1-Bit-Zhlern (0,1).                             */\
      x64 = (x64 & 0x5555555555555555UL) + ((x64 & 0xAAAAAAAAAAAAAAAAUL) >> 1),\
      /* x64 besteht aus 32 2-Bit-Zhlern (0,1,2).                           */\
      x64 = (x64 & 0x3333333333333333UL) + ((x64 & 0xCCCCCCCCCCCCCCCCUL) >> 2),\
      /* x64 besteht aus 16 4-Bit-Zhlern (0,1,2,3,4).                       */\
      x64 = (uint32)(x64 + (x64 >> 32)),				       \
      /* x64 besteht aus 8 4-Bit-Zhlern (0,...,8).                          */\
      x64 = (x64 & 0x0F0F0F0FUL) + ((x64 & 0xF0F0F0F0UL) >> 4),		       \
      /* x64 besteht aus 4 8-Bit-Zhlern (0,...,16).                         */\
      x64 = (x64 & 0x00FF00FFU) + ((x64 & 0xFF00FF00U) >> 8),		       \
      /* x64 besteht aus 2 16-Bit-Zhlern (0,...,32).                        */\
      x64 = (x64 & 0x0000FFFFU) + (x64 >> 16)				       \
      /* x64 besteht aus 1 16-Bit-Zhler (0,...,64).                         */\
    )

uintL logcount (const cl_I& x)
{
	if (fixnump(x))
	  { var uint32 x32 = FN_to_L(x); // x als 32-Bit-Zahl
	    if (FN_L_minusp(x,(sint32)x32)) { x32 = ~ x32; } // falls <0, komplementieren
	    logcount_32(); // Bits von x32 zhlen
	    return x32;
	  }
          else
          { var const uintD* MSDptr;
            var uintC len;
            BN_to_NDS_nocopy(x, MSDptr=,len=,); // DS zu x bilden, len>0.
           {var uintL bitcount = 0; // Bitzhler
            var const uintD* ptr = MSDptr; // luft durch die Digits durch
            var uintD sign = sign_of_sintD(mspref(ptr,0)); // Vorzeichen
            #if (intDsize==8)
            dotimespC(len,len,
              { var uintD x8 = msprefnext(ptr) ^ sign; // nchstes intDsize-Bit-Paket,
                                      // bei negativen Zahlen komplementiert
                // Bits von x8 zhlen, Gesamtzhler erhhen:
                bitcount += (uintL)(logcount_8(), x8);
              });
            #endif
            #if (intDsize==16)
            dotimespC(len,len,
              { var uintD x16 = msprefnext(ptr) ^ sign; // nchstes intDsize-Bit-Paket,
                                      // bei negativen Zahlen komplementiert
                // Bits von x16 zhlen, Gesamtzhler erhhen:
                bitcount += (uintL)(logcount_16(), x16);
              });
            #endif
            #if (intDsize==32)
            dotimespC(len,len,
              { var uintD x32 = msprefnext(ptr) ^ sign; // nchstes intDsize-Bit-Paket,
                                      // bei negativen Zahlen komplementiert
                // Bits von x32 zhlen, Gesamtzhler erhhen:
                bitcount += (uintL)(logcount_32(), x32);
              });
            #endif
            #if (intDsize==64)
            dotimespC(len,len,
              { var uintD x64 = msprefnext(ptr) ^ sign; // nchstes intDsize-Bit-Paket,
                                      // bei negativen Zahlen komplementiert
                // Bits von x64 zhlen, Gesamtzhler erhhen:
                bitcount += (uintL)(logcount_64(), x64);
              });
            #endif
            // 0 <= bitcount < intDsize*2^intCsize.
            return bitcount;
          }}
}
