// Output functions.

#ifndef _CL_PRINT_H
#define _CL_PRINT_H

#include "cl_number.h"
#include "cl_io.h"
#include "cl_output.h"

// Liefert zu einem Integer >=0  (write-to-string integer :base 10 :radix nil),
// also die Ziffernfolge als String.
// Mit cl_malloc_hook() alloziert, mit cl_free_hook() freizugeben.
extern char * cl_decimal_string (const cl_I& x);

// Gibt ein Integer aus.
// print_integer(stream,base,z);
// > z: Integer
// > base: Basis (>=2, <=36)
// > stream: Stream
extern void print_integer (cl_ostream stream, unsigned int base, const cl_I& z);
// Dasselbe als String. Mit cl_malloc_hook() alloziert, mit cl_free_hook() freizugeben.
extern char * print_integer_to_string (unsigned int base, const cl_I& z);

// Gibt eine rationale Zahl aus.
// print_rational(stream,base,z);
// > z: rationale Zahl
// > base: Basis (>=2, <=36)
// > stream: Stream
extern void print_rational (cl_ostream stream, unsigned int base, const cl_RA& z);


// Gibt ein Float aus.
// print_float(stream,z);
// > z: Float
// > stream: Stream
extern void print_float (cl_ostream stream, const cl_print_float_flags& flags, const cl_F& z);

// Gibt ein Float binr (sehr primitiv) aus.
// print_float_binary(stream,z);
// > z: Float
// > stream: Stream
extern void print_float_binary (cl_ostream stream, const cl_F& z);

// Gibt eine reelle Zahl aus.
// print_real(stream,z);
// > z: reelle Zahl
// > stream: Stream
extern void print_real (cl_ostream stream, const cl_print_real_flags& flags, const cl_R& z);

// Gibt eine komplexe Zahl aus.
// print_complex(stream,z);
// > z: komplexe Zahl
// > stream: Stream
extern void print_complex (cl_ostream stream, const cl_print_number_flags& flags, const cl_N& z);

// Gibt einen Vektor aus.
// print_vector(stream,flags,fun,z);
// > stream: Stream
// > flags: Flags
// > fun: Ausgabefunktion fr die einzelnen Elemente
// > vector: Vektor
class cl_GV_N;
extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_GV_N& vector);
class cl_SV_N;
extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_SV_N& vector);

#endif /* _CL_PRINT_H */
