// cl_fgetline().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_string.h"


// Implementation.

#ifdef CL_IO_IOSTREAM

#include "cl_io.h"
#include "cl_spushstring.h"

cl_string cl_fgetline (cl_istream stream, int n, char delim)
{
	var cl_spushstring buffer;
	// Handling of eofp is tricky: EOF is reached when (!stream.good()) || (stream.get()==EOF).
	while (stream.good()) {
		var int c = stream.get();
		if (c==EOF)
			break;	// ios::eofbit already set
		if (c==delim)
			break;
		if (--n <= 0) {
			stream.unget();
			stream.set(ios::failbit);
			break;
		}
		buffer.push(c);
	}
	return buffer.contents();
}

#endif
