// expx().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

#include "cl_real.h"
#include "cl_float.h"
#include "cl_low.h"
#include "cl_F.h"
#include "cl_lfloat.h"
#include "cl_LF.h"
#include "cl_integer.h"

cl_F expx_naive (const cl_F& x)
{
// Methode:
// e := Exponent aus (decode-float x), d := (float-digits x)
// Bei x=0.0 oder e<-d liefere 1.0
//   (denn bei e<=-d-1 ist abs(exp(x)-1) = abs(x)+O(x^2) < 2^(-d-1),
//    also ist exp(x), auf d Bits gerundet, gleich 1.0).
// Bei e<=-sqrt(d) verwende die Potenzreihe
//   exp(x) = sum(j=0..inf,x^j/j!):
//   b:=1, i:=0, sum:=0,
//   while (/= sum (setq sum (+ sum b))) do b:=b*x/(i+1), i:=i+1.
//   Ergebnis sum.
// Sonst setze y := x/2 = (scale-float x -1),
//   berechne rekursiv z:=exp(y) und liefere z^2.
// Aufwand: asymptotisch d^2.5 .

	if (zerop(x))
		return cl_float(1,x);
	var uintL d = float_digits(x);
	var sintL e = float_exponent(x);
	if (e < -(sintL)d) // e < -d ?
		return cl_float(1,x); // ja -> 1.0 als Ergebnis
 {	Mutable(cl_F,x);
	var uintL k = 0; // Rekursionszhler k:=0
	// Bei e <= -1-limit_slope*floor(sqrt(d)) kann die Potenzreihe
	// angewandt werden. limit_slope = 1.0 ist nicht schlecht. Fr
	// d > 1600 scheint der Bereich 2.0 <= limit_slope <= 2.6 am besten
	// zu sein (mit bis zu 15% Beschleunigung gegenber limit_slope = 1.0),
	// aber in diesem Bereich rechnen wir gar nicht.
	// Wir whlen limit_slope = 1.5.
	var sintL e_limit = -1-floor(isqrt(d)*3,2); // -1-floor(sqrt(d))
	if (e > e_limit) {
		// e > -1-floor(sqrt(d)) -> mu |x| verkleinern.
		k = e - e_limit;
		x = scale_float(x,-(sintL)k); // x := x/2^k
		// Neuer Exponent = e-k = e_limit.
	}
	// Potenzreihe anwenden:
	var int i = 0;
	var cl_F b = cl_float(1,x); // b := (float 1 x)
	var cl_F sum = cl_float(0,x); // sum := (float 0 x)
	loop {
		var cl_F new_sum = sum + b;
		if (new_sum == sum) // = sum ?
			break; // ja -> Potenzreihe abbrechen
		sum = new_sum;
		i = i+1;
		b = (b*x)/cl_float(i,x); // b := b*x/i
	}
	var cl_F& result = sum; // sum als Ergebnis
	// Wegen Rekursion noch k mal quadrieren:
	for ( ; k > 0; k--)
		result = square(result);
	return result;
}}
// Bit complexity (N = length(x)): O(N^(1/2)*M(N)).

cl_LF expx_ratseries (const cl_LF& x)
{
	// [Jonathan M. Borwein, Peter B. Borwein: Pi and the AGM.
	//  Wiley 1987. Section 10.2.3]
	var uintC len = TheLfloat(x)->len;
	var cl_idecoded_float x_ = integer_decode_float(x);
	// x = (-1)^sign * 2^exponent * mantissa
	var uintL lq = cl_I_to_UL(- x_.exponent);
	var const cl_I& p = x_.mantissa;
	// Compute exp(p/2^lq) by splitting into pieces.
	var cl_boolean first_factor = cl_true;
	var cl_LF product;
	var uintL b1;
	var uintL b2;
	for (b1 = 0, b2 = 1; b1 < lq; b1 = b2, b2 = 2*b2) {
		// Piece containing bits b1+1..b2 after "decimal point"
		// in the binary representation of (p/2^lq).
		var uintL lqk = (lq >= b2 ? b2 : lq);
		var cl_I pk = ldb(p,cl_byte(lqk-b1,lq-lqk));
		// Compute exp(pk/2^lqk).
		if (!zerop(pk)) {
			if (minusp(x_.sign)) { pk = -pk; }
			var cl_LF factor = cl_exp_aux(pk,lqk,len);
			if (first_factor) {
				product = factor;
				first_factor = cl_false;
			} else
				product = product * factor;
		}
	}
	if (first_factor)
		return cl_I_to_LF(1,len);
	else
		return product;
}
// Bit complexity (N = length(x)): O(log(N)^2*M(N)).

// Timings of the above algorithms, on an i486 33 MHz, running Linux,
// applied to x = sqrt(2)-1 = 0.414...
// ("naive" with adaptive limit_slope, about sqrt(ln(len)).)
//   N      naive  ratseries
//   10     0.019   0.040
//   25     0.082   0.096
//   50     0.36    0.24
//  100     1.52    0.69
//  250    11.3     3.1
//  500    53.5    11.0
// 1000   201      33
// ==> ratseries faster for N >= 27. Since the caller extends the length,
// here this means len>=29.
