// cl_ln10().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

#include "cl_lfloat.h"
#include "cl_LF.h"

cl_LF cl_ln10 (uintC len)
{
	var uintC oldlen = TheLfloat(cl_LF_ln10)->len; // vorhandene Lnge
	if (len < oldlen)
		return shorten(cl_LF_ln10,len);
	if (len == oldlen)
		return cl_LF_ln10;

	// TheLfloat(cl_LF_ln10)->len um mindestens einen konstanten Faktor
	// > 1 wachsen lassen, damit es nicht zu hufig nachberechnet wird:
	var uintC newlen = len;
	oldlen += floor(oldlen,2); // oldlen * 3/2
	if (newlen < oldlen)
		newlen = oldlen;

	// gewnschte > vorhandene Lnge -> mu nachberechnen:
	cl_LF_ln10 = ln(cl_I_to_LF(10,newlen)); // (ln 10.0)
	return (len < newlen ? shorten(cl_LF_ln10,len) : cl_LF_ln10);
}
