// sin().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_real.h"


// Implementation.

#include "cl_R_tran.h"
#include "cl_F.h"
#include "cl_integer.h"
#include "cl_lfloat.h"
#include "cl_LF.h"

cl_R sin (const cl_R& x)
{
// Methode:
// x rational -> bei x=0 0 als Ergebnis, sonst x in Float umwandeln.
// x Float -> Genauigkeit erhhen,
//   (q,r) := (round x (float pi/2 x)), so da |r|<=pi/4.
//   y:=(sin(r)/r)^2 errechnen.
//   Falls q gerade:
//     sin(r) berechnen: r*sqrt(y).
//   Falls q ungerade:
//     cos(r) berechnen:
//       e := Exponent aus (decode-float r), d := (float-digits r)
//       Bei r=0.0 oder e<=-d/2 liefere 1.0
//         (denn bei e<=-d/2 ist r^2/2 < 2^(-d)/2 = 2^(-d-1), also
//         1 >= cos(r) > 1-r^2/2 > 1-2^(-d-1),
//         also ist cos(r), auf d Bits gerundet, gleich 1.0).
//       Sonst sqrt(1-r^2*y).
//   Falls q == 2,3 mod 4, Vorzeichenwechsel.

	var cl_F xx;
	if (rationalp(x)) {
		DeclareType(cl_RA,x);
		if (zerop(x)) // x=0 -> 0 als Ergebnis
			return 0;
		xx = cl_float(x); // sonst in Float umwandeln
	} else {
		DeclareType(cl_F,x);
		xx = x;
	}
	// x Float
	// Rechengenauigkeit erhhen und durch pi/2 dividieren:
	var cl_F z;
	var cl_I q;
	if (longfloatp(xx)) {
		DeclareType(cl_LF,xx);
		if (TheLfloat(xx)->len >= 1350) {
			var cl_F_div_t q_r = cl_round_pi2(extend(xx,TheLfloat(xx)->len+1));
			q = q_r.quotient;
			var cl_LF r = The(cl_LF)(q_r.remainder);
			var cl_LF_cos_sin_t trig = cossin_ratseries(r);
			if (evenp(q))
				z = cl_float(trig.sin,xx);
			else
				z = cl_float(trig.cos,xx);
		} else {
			var cl_F_div_t q_r = cl_round_pi2(cl_F_extendsqrt(xx));
			q = q_r.quotient;
			var cl_LF r = The(cl_LF)(q_r.remainder);
			var cl_LF y = sinx_naive(r); // y := sin(r)^2
			if (evenp(q)) {
				// sin(r) berechnen:
				z = cl_float(sqrt(y),xx);
				if (minusp(r))
					z = -z;
			} else {
				// cos(r) berechnen:
				if (zerop(r) || (float_exponent(r) <= (-(sintL)float_digits(r))>>1))
					z = cl_float(1,xx); // cos(r) = 1.0
				else
					z = cl_float(sqrt(1 - y),xx); // sqrt(1-y)
			}
		}
	} else {
		var cl_F_div_t q_r = cl_round_pi2(cl_F_extendsqrt(xx));
		q = q_r.quotient;
		var cl_F& r = q_r.remainder;
		var cl_F y = sinxbyx_naive(r); // y := (sin(r)/r)^2
		if (evenp(q)) {
			// sin(r) berechnen:
			z = cl_float(r*sqrt(y),xx);
		} else {
			// cos(r) berechnen:
			if (zerop(r) || (float_exponent(r) <= (-(sintL)float_digits(r))>>1))
				z = cl_float(1,xx); // cos(r) = 1.0
			else
				z = cl_float(sqrt(1 - square(r)*y),xx); // sqrt(1-r^2*y)
		}
	}
	// evtl. Vorzeichenwechsel:
	if (cl_I_to_UL(logand(q,2))==0)
		return z;
	else
		return -z;
}

// Timings of the two algorithms, on an i486 33 MHz, running Linux,
// applied to x = sqrt(2)-1 = 0.414...
//   N      naive  ratseries
//   10     0.009   0.039
//   25     0.035   0.119
//   50     0.13    0.34
//  100     0.51    1.09
//  250     3.4     5.3
//  500    14.3    19.1
// 1000    60      62
// 2500   298     247
// ==> ratseries faster for N >= 1350.
