#include <cl_number.h>
#include <cl_io.h>
#include <cl_integer.h>
#include <cl_random.h>
#include <stdlib.h>
#include <string.h>
#include <cl_timing.h>
#include <cl_print.h>
#include <cl_malloc.h>
#include <cl_abort.h>

main (int argc, char * argv[])
{
	int repetitions = 1;
	if ((argc >= 3) && !strcmp(argv[1],"-r")) {
		repetitions = atoi(argv[2]);
		argc -= 2; argv += 2;
	}
	if (argc < 2)
		exit(1);
	cl_I m = cl_I(argv[1]);
	cl_I M = (cl_I)1 << (intDsize*m);
	cl_I a = random_I(M);
	// One run to fill the cache.
	{
		char* p = cl_decimal_string(a);
		cl_free_hook(p);
	}
	// Now start the timing.
	{ CL_TIMING;
	  for (int rep = repetitions; rep > 0; rep--)
	    { char* p = cl_decimal_string(a); cl_free_hook(p); }
	}
}
