// cl_round_pi().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

cl_F_div_t cl_round_pi (const cl_F& x)
{
	if (float_exponent(x) <= 0)
		// Exponent <=0 -> |x|<1 -> |x/pi| < 1/2, also Division unntig
		return cl_F_div_t(0,x); // Quotient 0, Rest x
	else
		// x durch pi (mit hinreichender Genauigkeit) dividieren
		return round2(x,cl_pi(x));
}
