//
// monty.cxx
//
// Leonard Janke
// August 1996

#include "monty.hxx"

Monty::Monty(const LInteger& N)
{
  sizeOfN=N._size;

  LInteger R=LMath::TwoToThe(sizeOfN*LMisc::bitsPerInt);
  LInteger RInv, NPrime;

  assert ( LMath::ExtendedEuclid(R,N,RInv,NPrime) == 1 );

  if ( RInv < 0 )
    {
      RInv+=N;
      NPrime-=R;
    }

  NPrime=LMath::Negative(NPrime);

  nPrimeModB=NPrime._magnitude[NPrime._size-1];

  LInteger RSquaredModN=R*R%N;
  rSquaredModN=new unsigned int[sizeOfN];
  int offset=sizeOfN-RSquaredModN._size;
  LMisc::MemZero(rSquaredModN,offset);

  LMisc::MemCopy(RSquaredModN._magnitude,rSquaredModN+offset,
		 RSquaredModN._size-offset);

  n=new unsigned int[sizeOfN];
  LMisc::MemCopy(N._magnitude,n,sizeOfN);

  TScratch=new unsigned int[sizeOfN*2+1];
}

Monty::~Monty()
{
  delete[] rSquaredModN;
  delete[] n;
  delete[] TScratch;
}
