// monty.inl
//
// Leonard Janke
// August 1996

inline void Monty::MontyReduceTScratch()
{
  for (int i=2*sizeOfN; i>=sizeOfN+1; i--)
    BMath::BasicMultiply(n,*(TScratch+i)*nPrimeModB,TScratch+i-sizeOfN,
			 sizeOfN);

  if ( *TScratch == 1 || BMath::GreaterThanOrEqualTo(TScratch+1,n,sizeOfN) )
    BMath::RippleSubtract(TScratch+1,n,TScratch+1,sizeOfN);
}

inline void Monty::MontyMultiply(const unsigned int* a, const unsigned int* b, 
				 unsigned int* result)
{
  LMisc::MemZero(TScratch,2*sizeOfN+1);
  BMath::Multiply(a,sizeOfN,b,sizeOfN,TScratch+1);
  MontyReduceTScratch();
  LMisc::MemCopy(TScratch+1,result,sizeOfN);	
}

inline void Monty::MontySquare(const unsigned int* a, unsigned int* result)
{
  LMisc::MemZero(TScratch,2*sizeOfN+1);
  BMath::Square(a,sizeOfN,TScratch+1);
  MontyReduceTScratch();
  LMisc::MemCopy(TScratch+1,result,sizeOfN);	
}

inline void Monty::ConvertToMonty(unsigned int* a)
{
  MontyMultiply(a,rSquaredModN,a);
}

inline void Monty::ConvertFromMonty(unsigned int* a)
{
  LMisc::MemZero(TScratch,sizeOfN+1);
  LMisc::MemCopy(a,TScratch+sizeOfN+1,sizeOfN);
  MontyReduceTScratch();
  LMisc::MemCopy(TScratch+1,a,sizeOfN);
}

