// BetterTelnet
// copyright 1997, 1998, 1999 Rolf Braun

// This is free software under the GNU General Public License (GPL). See the file COPYING
// which comes with the source code and documentation distributions for details.

// based on NCSA Telnet 2.7b5

// otp.c
// by Rolf Braun
// code to support OTP (One-Time Passwords), OPIE (One-time Passwords In Everything),
// and Bellcore's original S/Key system.

#include "otp.proto.h"
#include "md4.proto.h"
#include "md5.proto.h"
#include "configure.proto.h"
#include "DlogUtils.proto.h"
#include "rsinterf.proto.h"
#include "tekrgmac.proto.h"
#include "vrrgmac.proto.h"
#include "errors.proto.h"
#include "wind.h"
#include "network.proto.h"
#include "movableModal.h"
#include "parse.proto.h"

struct otpmdx_ctx {
	unsigned long state[4];
	unsigned long count[2];
	unsigned char buffer[64];
};

extern short scrn;
extern WindRec *screens;

/*static char inputPassword[256];*/
static Str255 inputPassword;

PROTO_UPP(OTPModalFilter, ModalFilter);
pascal short OTPModalFilter (DialogPtr dptr, EventRecord *evt, short *item);

SIMPLE_UPP(OTPModalFilter, ModalFilter);
pascal short OTPModalFilter(DialogPtr dptr, EventRecord *evt, short *item)
{
	short	key;
	short	start;
	short	end;
	Handle	hText;
	char	*pbuf;

/*
	short tempLen;
	if ((evt->what == keyDown) || (evt->what == autoKey))
		if ((((DialogPeek)dptr)->editField + 1) == 5) {
			key = evt->message & charCodeMask;
			if (key == 8) {
				inputPassword[0] = 0;
				SetTEText(dptr, 5, "\p");
				*item = 0;
				return -1;
			}
			if (key == 9) return 0;
			if (key < 32) {
				*item = 0;
				StdFilterProc(dptr, evt, item);
				return -1;
			}
			tempLen = strlen(inputPassword);
			if (tempLen < 250) {
				inputPassword[tempLen] = key;
				inputPassword[tempLen+1] = 0;
			}
			evt->message = (evt->message & 0xFFFFFF00) + '';
			return 0;
		}
*/
	if ((evt->what == keyDown || evt->what == autoKey) && ((DialogPeek)dptr)->editField + 1 == 5) {
		if ( !PasswordFilter(dptr, evt, inputPassword, 250) ) {
			return StdFilterProc(dptr, evt, item);
		}
	}

	*item = 0;
	StdFilterProc(dptr, evt, item);
	if (*item != 0) return -1;
	return 0;
}

void otpgetselection(char *selection)
{
	short i;
	Handle charh;

	*selection = 0;

// Here we check for a valid text selection.
	if (TelInfo->numwindows<1) return;					// No windows? No problem!
	if (MacRGfindwind(FrontWindow()) >= 0) return;		// ICR is not text.
	if (RGgetdnum(FrontWindow()) > -1) return;			// Tektronix is also not text.
	if ((i = RSfindvwind(FrontWindow())) < 0) return;	// It had better be a text window...
	if (!RSTextSelected(i)) return;						// ...with something selected!

	charh = RSGetTextSel(i, 0);							// Get the text selection

	if (charh == (char **)-1L) OutOfMemory(400);
	if (charh != (char **)0L) {
		if ((GetHandleSize(charh) != 0) && (GetHandleSize(charh) < 250)) {
			HLock(charh);
			BlockMoveData(*charh, selection + 1, GetHandleSize(charh));
			selection[0] = GetHandleSize(charh);
		}
		DisposeHandle(charh);
	}
}

void otpinterface(short mode, char *parsechallenge, struct WindRec *tw,
				  short usehexin, short noprompt, char *passwordin, short savepass)
{
	short ditem, usehex, i;
	DialogPtr dptr;
	static Str255 challenge, response, tempstring;

	usehex = usehexin;

	if (mode) {
		strcpy((char *)challenge, parsechallenge);
		c2pstr((char *)challenge);
	}
	else
		otpgetselection((char *) challenge);

	if (mode && noprompt)
	if (passwordin[0]) {
		pstrcpy(tempstring, (unsigned char *)passwordin);
		p2cstr(tempstring);
		p2cstr(challenge);
		otpgenerator((char *)challenge, (char *)response, (char *)tempstring, usehex);
		SendStringAsIfTyped(tw, (char *)response, strlen((char *)response));
		//	If crmap is on, send CR-NULL instead of CR-LF.
/*		if (tw->crmap) 
			SendStringAsIfTyped(tw,"\015\0",2);
		else
			SendStringAsIfTyped(tw,"\015\012",2); //UNIVAC fix
		return; */
		SendCRAsIfTyped(tw);
	}

	SetUpMovableModalMenus();
	dptr = GetNewDialog(8000, 0, (WindowPtr)-1);

	SetDialogDefaultItem(dptr, 1);
	SetDialogCancelItem(dptr, 3);
	SetDialogTracksCursor(dptr, 1);

	SetTEText(dptr, 4, challenge);

	if (mode && usehex)
		SetCntrl(dptr, 8, 1);
	else SetCntrl(dptr, 7, 1);
	ditem = 0;
	inputPassword[0] = 0;
	if (gApplicationPrefs->globalSavePass) {
		strcpy((char *)inputPassword + 1, TelInfo->otpword);
		inputPassword[0] = strlen(TelInfo->otpword);
		for (i = 1; i <= inputPassword[0]; i++)
			tempstring[i] = '';
		tempstring[0] = inputPassword[0];
		SetTEText(dptr, 5, tempstring);
	}

	if (mode) {
		if (passwordin[0]) {
			pstrcpy(inputPassword, (unsigned char *)passwordin);
			//p2cstr((unsigned char *)inputPassword);
			for (i = 1; i <= inputPassword[0]; i++)
				tempstring[i] = '';
			tempstring[0] = inputPassword[0];
			SetTEText(dptr, 5, tempstring);
		}
	}

	if (mode || challenge[0])
		SelectDialogItemText(dptr, 5, 0, 32767);

	while ((ditem != 1) && (ditem != 3)) {
		movableModalDialog(OTPModalFilterUPP, &ditem);

		switch (ditem) {
			case 7:
			SetCntrl(dptr, 7, 1);
			SetCntrl(dptr, 8, 0);
			goto generate;

			case 8:
			SetCntrl(dptr, 7, 0);
			SetCntrl(dptr, 8, 1);

			case 2:
			generate:
			GetTEText(dptr, 4, challenge);
			usehex = GetCntlVal(dptr, 8);
			p2cstr(challenge);
			inputPassword[inputPassword[0] + 1] = '\0';
			otpgenerator((char *)challenge, (char *)response, (char *)inputPassword + 1, usehex);
			c2pstr((char *)response);
			SetTEText(dptr, 6, response);
		}
	}
	if (ditem == 1) {
		GetTEText(dptr, 4, challenge);
		usehex = GetCntlVal(dptr, 8);
		p2cstr(challenge);
		inputPassword[inputPassword[0] + 1] = '\0';
		otpgenerator((char *)challenge, (char *)response, (char *)inputPassword + 1, usehex);
		if (inputPassword[0] <= 63 && gApplicationPrefs->globalSavePass)
			strncpy(TelInfo->otpword, (char *)inputPassword + 1, inputPassword[0]);
		if (savepass && inputPassword[0] <= 63) {
			// RAB BetterTelnet 1.2.1
			pstrcpy((unsigned char *)passwordin, inputPassword);
		}
	}
	DisposeDialog(dptr);
	ResetMenus();
	if (TelInfo->numwindows<1) return;					// No windows? No problem!
	if (ditem == 1) {
		if (mode) {
			SendStringAsIfTyped(tw, (char *)response, strlen((char *)response));
/*			//	If crmap is on, send CR-NULL instead of CR-LF.
			if (tw->crmap) 
				SendStringAsIfTyped(tw,"\015\0",2);
			else
				SendStringAsIfTyped(tw,"\015\012",2); //UNIVAC fix */
			SendCRAsIfTyped(tw);
		}
		else {
			SendStringAsIfTyped(&screens[scrn], (char *)response, strlen((char *)response));
			//	If crmap is on, send CR-NULL instead of CR-LF.
/*			if (screens[scrn].crmap) 
				SendStringAsIfTyped(&screens[scrn],"\015\0",2);
			else
				SendStringAsIfTyped(&screens[scrn],"\015\012",2); //UNIVAC fix */
			SendCRAsIfTyped(&screens[scrn]);
		}
	}
}

void otpgenerator(char *challenge, char *response, char *password, short usehex)
{
	short algorithm;
	unsigned long sequence;
	char key[8];
	char *cptr;
	char *seed;
	static char buffer[256];

	*response = 0;
	cptr = challenge;

	if (strncmp(challenge, "otp-", 4)) {
		if (strncmp(challenge, "s/key ", 6))
			return;
		else {
			cptr += 6;
			algorithm = 0;
		}
	} else {
		cptr += 4;
		if (strncmp(cptr, "md4 ", 4)) {
			if (strncmp(cptr, "md5 ", 4)) {
				if (strncmp(cptr, "sha1 ", 5))
					return;
				else algorithm = 2;
				cptr++;
			}
			else algorithm = 1;
		} else algorithm = 0;
		cptr += 4;
	}

	if ((sequence = strtoul(cptr, &cptr, 10)) > 9999)
		return;

	while(*cptr && isspace(*cptr)) cptr++;
	if (!*cptr)
		return;

	seed = cptr;
	while (*cptr && !isspace(*cptr)) cptr++;
	*cptr = 0;

	if ((sequence < 1) || (sequence > 9999))
		return;

	if ((strlen(seed) + strlen(password)) > 250)
		return;

	strcpy(buffer, seed);
	strcat(buffer, password);

	otphashlen(algorithm, buffer, key);

	while (sequence-- != 0)
		otphash(algorithm, key);

	if (usehex)
		otpbtoh(key, response);
	else
		otpbtoe(key, response);
}

void otphashlen(short algorithm, char *buffer, char *key)
{
	static struct otpmdx_ctx mdx;
	unsigned long mdx_tmp[4];
	unsigned long sha1_tmp[5];
	static SHA1_CTX sha1data;
	unsigned long *results = (unsigned long *) key;

	if (algorithm == 2) {
		SHA1Init(&sha1data);
		SHA1Update(&sha1data, (unsigned char *)buffer, strlen(buffer));
		SHA1Final((unsigned char *)sha1_tmp, &sha1data);
		results[0] = sha1_tmp[0] ^ sha1_tmp[2] ^ sha1_tmp[4];
		results[1] = sha1_tmp[1] ^ sha1_tmp[3];
		return;
	}

	if (algorithm == 1) {
		otpmd5init(&mdx);
		otpmd5update(&mdx, (unsigned char *)buffer, strlen(buffer));
		otpmd5final((unsigned char *)mdx_tmp, &mdx);
	} else {
		otpmd4init(&mdx);
		otpmd4update(&mdx, (unsigned char *)buffer, strlen(buffer));
		otpmd4final((unsigned char *)mdx_tmp, &mdx);
	}
	results[0] = mdx_tmp[0] ^ mdx_tmp[2];
	results[1] = mdx_tmp[1] ^ mdx_tmp[3];
}

void otphash(short algorithm, char *key)
{
	static struct otpmdx_ctx mdx;
	unsigned long mdx_tmp[4];
	unsigned long sha1_tmp[5];
	static SHA1_CTX sha1data;
	unsigned long *results = (unsigned long *) key;

	if (algorithm == 2) {
		SHA1Init(&sha1data);
		SHA1Update(&sha1data, (unsigned char *)key, 8);
		SHA1Final((unsigned char *)sha1_tmp, &sha1data);
		results[0] = sha1_tmp[0] ^ sha1_tmp[2] ^ sha1_tmp[4];
		results[1] = sha1_tmp[1] ^ sha1_tmp[3];
		return;
	}

	if (algorithm) {
		otpmd5init(&mdx);
		otpmd5update(&mdx, (unsigned char *)key, 8);
		otpmd5final((unsigned char *)mdx_tmp, &mdx);
	} else {
		otpmd4init(&mdx);
		otpmd4update(&mdx, (unsigned char *)key, 8);
		otpmd4final((unsigned char *)mdx_tmp, &mdx);
	}
	results[0] = mdx_tmp[0] ^ mdx_tmp[2];
	results[1] = mdx_tmp[1] ^ mdx_tmp[3];
}

static char hextochar[16] = 
{'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

char* otpbtoh (char *in, char *out)
{
  short i;
  char *c = out;

  for (i = 0; i < 4; i++) {
    *(c++) = hextochar[((*in) >> 4) & 0x0f];
    *(c++) = hextochar[(*in++) & 0x0f];
    *(c++) = hextochar[((*in) >> 4) & 0x0f];
    *(c++) = hextochar[(*in++) & 0x0f];
    *(c++) = ' ';
  }
  *(--c) = 0;

  return out;
}

static char otpenglish[2048][4] =
{
  "A",
  "ABE",
  "ACE",
  "ACT",
  "AD",
  "ADA",
  "ADD",
  "AGO",
  "AID",
  "AIM",
  "AIR",
  "ALL",
  "ALP",
  "AM",
  "AMY",
  "AN",
  "ANA",
  "AND",
  "ANN",
  "ANT",
  "ANY",
  "APE",
  "APS",
  "APT",
  "ARC",
  "ARE",
  "ARK",
  "ARM",
  "ART",
  "AS",
  "ASH",
  "ASK",
  "AT",
  "ATE",
  "AUG",
  "AUK",
  "AVE",
  "AWE",
  "AWK",
  "AWL",
  "AWN",
  "AX",
  "AYE",
  "BAD",
  "BAG",
  "BAH",
  "BAM",
  "BAN",
  "BAR",
  "BAT",
  "BAY",
  "BE",
  "BED",
  "BEE",
  "BEG",
  "BEN",
  "BET",
  "BEY",
  "BIB",
  "BID",
  "BIG",
  "BIN",
  "BIT",
  "BOB",
  "BOG",
  "BON",
  "BOO",
  "BOP",
  "BOW",
  "BOY",
  "BUB",
  "BUD",
  "BUG",
  "BUM",
  "BUN",
  "BUS",
  "BUT",
  "BUY",
  "BY",
  "BYE",
  "CAB",
  "CAL",
  "CAM",
  "CAN",
  "CAP",
  "CAR",
  "CAT",
  "CAW",
  "COD",
  "COG",
  "COL",
  "CON",
  "COO",
  "COP",
  "COT",
  "COW",
  "COY",
  "CRY",
  "CUB",
  "CUE",
  "CUP",
  "CUR",
  "CUT",
  "DAB",
  "DAD",
  "DAM",
  "DAN",
  "DAR",
  "DAY",
  "DEE",
  "DEL",
  "DEN",
  "DES",
  "DEW",
  "DID",
  "DIE",
  "DIG",
  "DIN",
  "DIP",
  "DO",
  "DOE",
  "DOG",
  "DON",
  "DOT",
  "DOW",
  "DRY",
  "DUB",
  "DUD",
  "DUE",
  "DUG",
  "DUN",
  "EAR",
  "EAT",
  "ED",
  "EEL",
  "EGG",
  "EGO",
  "ELI",
  "ELK",
  "ELM",
  "ELY",
  "EM",
  "END",
  "EST",
  "ETC",
  "EVA",
  "EVE",
  "EWE",
  "EYE",
  "FAD",
  "FAN",
  "FAR",
  "FAT",
  "FAY",
  "FED",
  "FEE",
  "FEW",
  "FIB",
  "FIG",
  "FIN",
  "FIR",
  "FIT",
  "FLO",
  "FLY",
  "FOE",
  "FOG",
  "FOR",
  "FRY",
  "FUM",
  "FUN",
  "FUR",
  "GAB",
  "GAD",
  "GAG",
  "GAL",
  "GAM",
  "GAP",
  "GAS",
  "GAY",
  "GEE",
  "GEL",
  "GEM",
  "GET",
  "GIG",
  "GIL",
  "GIN",
  "GO",
  "GOT",
  "GUM",
  "GUN",
  "GUS",
  "GUT",
  "GUY",
  "GYM",
  "GYP",
  "HA",
  "HAD",
  "HAL",
  "HAM",
  "HAN",
  "HAP",
  "HAS",
  "HAT",
  "HAW",
  "HAY",
  "HE",
  "HEM",
  "HEN",
  "HER",
  "HEW",
  "HEY",
  "HI",
  "HID",
  "HIM",
  "HIP",
  "HIS",
  "HIT",
  "HO",
  "HOB",
  "HOC",
  "HOE",
  "HOG",
  "HOP",
  "HOT",
  "HOW",
  "HUB",
  "HUE",
  "HUG",
  "HUH",
  "HUM",
  "HUT",
  "I",
  "ICY",
  "IDA",
  "IF",
  "IKE",
  "ILL",
  "INK",
  "INN",
  "IO",
  "ION",
  "IQ",
  "IRA",
  "IRE",
  "IRK",
  "IS",
  "IT",
  "ITS",
  "IVY",
  "JAB",
  "JAG",
  "JAM",
  "JAN",
  "JAR",
  "JAW",
  "JAY",
  "JET",
  "JIG",
  "JIM",
  "JO",
  "JOB",
  "JOE",
  "JOG",
  "JOT",
  "JOY",
  "JUG",
  "JUT",
  "KAY",
  "KEG",
  "KEN",
  "KEY",
  "KID",
  "KIM",
  "KIN",
  "KIT",
  "LA",
  "LAB",
  "LAC",
  "LAD",
  "LAG",
  "LAM",
  "LAP",
  "LAW",
  "LAY",
  "LEA",
  "LED",
  "LEE",
  "LEG",
  "LEN",
  "LEO",
  "LET",
  "LEW",
  "LID",
  "LIE",
  "LIN",
  "LIP",
  "LIT",
  "LO",
  "LOB",
  "LOG",
  "LOP",
  "LOS",
  "LOT",
  "LOU",
  "LOW",
  "LOY",
  "LUG",
  "LYE",
  "MA",
  "MAC",
  "MAD",
  "MAE",
  "MAN",
  "MAO",
  "MAP",
  "MAT",
  "MAW",
  "MAY",
  "ME",
  "MEG",
  "MEL",
  "MEN",
  "MET",
  "MEW",
  "MID",
  "MIN",
  "MIT",
  "MOB",
  "MOD",
  "MOE",
  "MOO",
  "MOP",
  "MOS",
  "MOT",
  "MOW",
  "MUD",
  "MUG",
  "MUM",
  "MY",
  "NAB",
  "NAG",
  "NAN",
  "NAP",
  "NAT",
  "NAY",
  "NE",
  "NED",
  "NEE",
  "NET",
  "NEW",
  "NIB",
  "NIL",
  "NIP",
  "NIT",
  "NO",
  "NOB",
  "NOD",
  "NON",
  "NOR",
  "NOT",
  "NOV",
  "NOW",
  "NU",
  "NUN",
  "NUT",
  "O",
  "OAF",
  "OAK",
  "OAR",
  "OAT",
  "ODD",
  "ODE",
  "OF",
  "OFF",
  "OFT",
  "OH",
  "OIL",
  "OK",
  "OLD",
  "ON",
  "ONE",
  "OR",
  "ORB",
  "ORE",
  "ORR",
  "OS",
  "OTT",
  "OUR",
  "OUT",
  "OVA",
  "OW",
  "OWE",
  "OWL",
  "OWN",
  "OX",
  "PA",
  "PAD",
  "PAL",
  "PAM",
  "PAN",
  "PAP",
  "PAR",
  "PAT",
  "PAW",
  "PAY",
  "PEA",
  "PEG",
  "PEN",
  "PEP",
  "PER",
  "PET",
  "PEW",
  "PHI",
  "PI",
  "PIE",
  "PIN",
  "PIT",
  "PLY",
  "PO",
  "POD",
  "POE",
  "POP",
  "POT",
  "POW",
  "PRO",
  "PRY",
  "PUB",
  "PUG",
  "PUN",
  "PUP",
  "PUT",
  "QUO",
  "RAG",
  "RAM",
  "RAN",
  "RAP",
  "RAT",
  "RAW",
  "RAY",
  "REB",
  "RED",
  "REP",
  "RET",
  "RIB",
  "RID",
  "RIG",
  "RIM",
  "RIO",
  "RIP",
  "ROB",
  "ROD",
  "ROE",
  "RON",
  "ROT",
  "ROW",
  "ROY",
  "RUB",
  "RUE",
  "RUG",
  "RUM",
  "RUN",
  "RYE",
  "SAC",
  "SAD",
  "SAG",
  "SAL",
  "SAM",
  "SAN",
  "SAP",
  "SAT",
  "SAW",
  "SAY",
  "SEA",
  "SEC",
  "SEE",
  "SEN",
  "SET",
  "SEW",
  "SHE",
  "SHY",
  "SIN",
  "SIP",
  "SIR",
  "SIS",
  "SIT",
  "SKI",
  "SKY",
  "SLY",
  "SO",
  "SOB",
  "SOD",
  "SON",
  "SOP",
  "SOW",
  "SOY",
  "SPA",
  "SPY",
  "SUB",
  "SUD",
  "SUE",
  "SUM",
  "SUN",
  "SUP",
  "TAB",
  "TAD",
  "TAG",
  "TAN",
  "TAP",
  "TAR",
  "TEA",
  "TED",
  "TEE",
  "TEN",
  "THE",
  "THY",
  "TIC",
  "TIE",
  "TIM",
  "TIN",
  "TIP",
  "TO",
  "TOE",
  "TOG",
  "TOM",
  "TON",
  "TOO",
  "TOP",
  "TOW",
  "TOY",
  "TRY",
  "TUB",
  "TUG",
  "TUM",
  "TUN",
  "TWO",
  "UN",
  "UP",
  "US",
  "USE",
  "VAN",
  "VAT",
  "VET",
  "VIE",
  "WAD",
  "WAG",
  "WAR",
  "WAS",
  "WAY",
  "WE",
  "WEB",
  "WED",
  "WEE",
  "WET",
  "WHO",
  "WHY",
  "WIN",
  "WIT",
  "WOK",
  "WON",
  "WOO",
  "WOW",
  "WRY",
  "WU",
  "YAM",
  "YAP",
  "YAW",
  "YE",
  "YEA",
  "YES",
  "YET",
  "YOU",
  "ABED",
  "ABEL",
  "ABET",
  "ABLE",
  "ABUT",
  "ACHE",
  "ACID",
  "ACME",
  "ACRE",
  "ACTA",
  "ACTS",
  "ADAM",
  "ADDS",
  "ADEN",
  "AFAR",
  "AFRO",
  "AGEE",
  "AHEM",
  "AHOY",
  "AIDA",
  "AIDE",
  "AIDS",
  "AIRY",
  "AJAR",
  "AKIN",
  "ALAN",
  "ALEC",
  "ALGA",
  "ALIA",
  "ALLY",
  "ALMA",
  "ALOE",
  "ALSO",
  "ALTO",
  "ALUM",
  "ALVA",
  "AMEN",
  "AMES",
  "AMID",
  "AMMO",
  "AMOK",
  "AMOS",
  "AMRA",
  "ANDY",
  "ANEW",
  "ANNA",
  "ANNE",
  "ANTE",
  "ANTI",
  "AQUA",
  "ARAB",
  "ARCH",
  "AREA",
  "ARGO",
  "ARID",
  "ARMY",
  "ARTS",
  "ARTY",
  "ASIA",
  "ASKS",
  "ATOM",
  "AUNT",
  "AURA",
  "AUTO",
  "AVER",
  "AVID",
  "AVIS",
  "AVON",
  "AVOW",
  "AWAY",
  "AWRY",
  "BABE",
  "BABY",
  "BACH",
  "BACK",
  "BADE",
  "BAIL",
  "BAIT",
  "BAKE",
  "BALD",
  "BALE",
  "BALI",
  "BALK",
  "BALL",
  "BALM",
  "BAND",
  "BANE",
  "BANG",
  "BANK",
  "BARB",
  "BARD",
  "BARE",
  "BARK",
  "BARN",
  "BARR",
  "BASE",
  "BASH",
  "BASK",
  "BASS",
  "BATE",
  "BATH",
  "BAWD",
  "BAWL",
  "BEAD",
  "BEAK",
  "BEAM",
  "BEAN",
  "BEAR",
  "BEAT",
  "BEAU",
  "BECK",
  "BEEF",
  "BEEN",
  "BEER",
  "BEET",
  "BELA",
  "BELL",
  "BELT",
  "BEND",
  "BENT",
  "BERG",
  "BERN",
  "BERT",
  "BESS",
  "BEST",
  "BETA",
  "BETH",
  "BHOY",
  "BIAS",
  "BIDE",
  "BIEN",
  "BILE",
  "BILK",
  "BILL",
  "BIND",
  "BING",
  "BIRD",
  "BITE",
  "BITS",
  "BLAB",
  "BLAT",
  "BLED",
  "BLEW",
  "BLOB",
  "BLOC",
  "BLOT",
  "BLOW",
  "BLUE",
  "BLUM",
  "BLUR",
  "BOAR",
  "BOAT",
  "BOCA",
  "BOCK",
  "BODE",
  "BODY",
  "BOGY",
  "BOHR",
  "BOIL",
  "BOLD",
  "BOLO",
  "BOLT",
  "BOMB",
  "BONA",
  "BOND",
  "BONE",
  "BONG",
  "BONN",
  "BONY",
  "BOOK",
  "BOOM",
  "BOON",
  "BOOT",
  "BORE",
  "BORG",
  "BORN",
  "BOSE",
  "BOSS",
  "BOTH",
  "BOUT",
  "BOWL",
  "BOYD",
  "BRAD",
  "BRAE",
  "BRAG",
  "BRAN",
  "BRAY",
  "BRED",
  "BREW",
  "BRIG",
  "BRIM",
  "BROW",
  "BUCK",
  "BUDD",
  "BUFF",
  "BULB",
  "BULK",
  "BULL",
  "BUNK",
  "BUNT",
  "BUOY",
  "BURG",
  "BURL",
  "BURN",
  "BURR",
  "BURT",
  "BURY",
  "BUSH",
  "BUSS",
  "BUST",
  "BUSY",
  "BYTE",
  "CADY",
  "CAFE",
  "CAGE",
  "CAIN",
  "CAKE",
  "CALF",
  "CALL",
  "CALM",
  "CAME",
  "CANE",
  "CANT",
  "CARD",
  "CARE",
  "CARL",
  "CARR",
  "CART",
  "CASE",
  "CASH",
  "CASK",
  "CAST",
  "CAVE",
  "CEIL",
  "CELL",
  "CENT",
  "CERN",
  "CHAD",
  "CHAR",
  "CHAT",
  "CHAW",
  "CHEF",
  "CHEN",
  "CHEW",
  "CHIC",
  "CHIN",
  "CHOU",
  "CHOW",
  "CHUB",
  "CHUG",
  "CHUM",
  "CITE",
  "CITY",
  "CLAD",
  "CLAM",
  "CLAN",
  "CLAW",
  "CLAY",
  "CLOD",
  "CLOG",
  "CLOT",
  "CLUB",
  "CLUE",
  "COAL",
  "COAT",
  "COCA",
  "COCK",
  "COCO",
  "CODA",
  "CODE",
  "CODY",
  "COED",
  "COIL",
  "COIN",
  "COKE",
  "COLA",
  "COLD",
  "COLT",
  "COMA",
  "COMB",
  "COME",
  "COOK",
  "COOL",
  "COON",
  "COOT",
  "CORD",
  "CORE",
  "CORK",
  "CORN",
  "COST",
  "COVE",
  "COWL",
  "CRAB",
  "CRAG",
  "CRAM",
  "CRAY",
  "CREW",
  "CRIB",
  "CROW",
  "CRUD",
  "CUBA",
  "CUBE",
  "CUFF",
  "CULL",
  "CULT",
  "CUNY",
  "CURB",
  "CURD",
  "CURE",
  "CURL",
  "CURT",
  "CUTS",
  "DADE",
  "DALE",
  "DAME",
  "DANA",
  "DANE",
  "DANG",
  "DANK",
  "DARE",
  "DARK",
  "DARN",
  "DART",
  "DASH",
  "DATA",
  "DATE",
  "DAVE",
  "DAVY",
  "DAWN",
  "DAYS",
  "DEAD",
  "DEAF",
  "DEAL",
  "DEAN",
  "DEAR",
  "DEBT",
  "DECK",
  "DEED",
  "DEEM",
  "DEER",
  "DEFT",
  "DEFY",
  "DELL",
  "DENT",
  "DENY",
  "DESK",
  "DIAL",
  "DICE",
  "DIED",
  "DIET",
  "DIME",
  "DINE",
  "DING",
  "DINT",
  "DIRE",
  "DIRT",
  "DISC",
  "DISH",
  "DISK",
  "DIVE",
  "DOCK",
  "DOES",
  "DOLE",
  "DOLL",
  "DOLT",
  "DOME",
  "DONE",
  "DOOM",
  "DOOR",
  "DORA",
  "DOSE",
  "DOTE",
  "DOUG",
  "DOUR",
  "DOVE",
  "DOWN",
  "DRAB",
  "DRAG",
  "DRAM",
  "DRAW",
  "DREW",
  "DRUB",
  "DRUG",
  "DRUM",
  "DUAL",
  "DUCK",
  "DUCT",
  "DUEL",
  "DUET",
  "DUKE",
  "DULL",
  "DUMB",
  "DUNE",
  "DUNK",
  "DUSK",
  "DUST",
  "DUTY",
  "EACH",
  "EARL",
  "EARN",
  "EASE",
  "EAST",
  "EASY",
  "EBEN",
  "ECHO",
  "EDDY",
  "EDEN",
  "EDGE",
  "EDGY",
  "EDIT",
  "EDNA",
  "EGAN",
  "ELAN",
  "ELBA",
  "ELLA",
  "ELSE",
  "EMIL",
  "EMIT",
  "EMMA",
  "ENDS",
  "ERIC",
  "EROS",
  "EVEN",
  "EVER",
  "EVIL",
  "EYED",
  "FACE",
  "FACT",
  "FADE",
  "FAIL",
  "FAIN",
  "FAIR",
  "FAKE",
  "FALL",
  "FAME",
  "FANG",
  "FARM",
  "FAST",
  "FATE",
  "FAWN",
  "FEAR",
  "FEAT",
  "FEED",
  "FEEL",
  "FEET",
  "FELL",
  "FELT",
  "FEND",
  "FERN",
  "FEST",
  "FEUD",
  "FIEF",
  "FIGS",
  "FILE",
  "FILL",
  "FILM",
  "FIND",
  "FINE",
  "FINK",
  "FIRE",
  "FIRM",
  "FISH",
  "FISK",
  "FIST",
  "FITS",
  "FIVE",
  "FLAG",
  "FLAK",
  "FLAM",
  "FLAT",
  "FLAW",
  "FLEA",
  "FLED",
  "FLEW",
  "FLIT",
  "FLOC",
  "FLOG",
  "FLOW",
  "FLUB",
  "FLUE",
  "FOAL",
  "FOAM",
  "FOGY",
  "FOIL",
  "FOLD",
  "FOLK",
  "FOND",
  "FONT",
  "FOOD",
  "FOOL",
  "FOOT",
  "FORD",
  "FORE",
  "FORK",
  "FORM",
  "FORT",
  "FOSS",
  "FOUL",
  "FOUR",
  "FOWL",
  "FRAU",
  "FRAY",
  "FRED",
  "FREE",
  "FRET",
  "FREY",
  "FROG",
  "FROM",
  "FUEL",
  "FULL",
  "FUME",
  "FUND",
  "FUNK",
  "FURY",
  "FUSE",
  "FUSS",
  "GAFF",
  "GAGE",
  "GAIL",
  "GAIN",
  "GAIT",
  "GALA",
  "GALE",
  "GALL",
  "GALT",
  "GAME",
  "GANG",
  "GARB",
  "GARY",
  "GASH",
  "GATE",
  "GAUL",
  "GAUR",
  "GAVE",
  "GAWK",
  "GEAR",
  "GELD",
  "GENE",
  "GENT",
  "GERM",
  "GETS",
  "GIBE",
  "GIFT",
  "GILD",
  "GILL",
  "GILT",
  "GINA",
  "GIRD",
  "GIRL",
  "GIST",
  "GIVE",
  "GLAD",
  "GLEE",
  "GLEN",
  "GLIB",
  "GLOB",
  "GLOM",
  "GLOW",
  "GLUE",
  "GLUM",
  "GLUT",
  "GOAD",
  "GOAL",
  "GOAT",
  "GOER",
  "GOES",
  "GOLD",
  "GOLF",
  "GONE",
  "GONG",
  "GOOD",
  "GOOF",
  "GORE",
  "GORY",
  "GOSH",
  "GOUT",
  "GOWN",
  "GRAB",
  "GRAD",
  "GRAY",
  "GREG",
  "GREW",
  "GREY",
  "GRID",
  "GRIM",
  "GRIN",
  "GRIT",
  "GROW",
  "GRUB",
  "GULF",
  "GULL",
  "GUNK",
  "GURU",
  "GUSH",
  "GUST",
  "GWEN",
  "GWYN",
  "HAAG",
  "HAAS",
  "HACK",
  "HAIL",
  "HAIR",
  "HALE",
  "HALF",
  "HALL",
  "HALO",
  "HALT",
  "HAND",
  "HANG",
  "HANK",
  "HANS",
  "HARD",
  "HARK",
  "HARM",
  "HART",
  "HASH",
  "HAST",
  "HATE",
  "HATH",
  "HAUL",
  "HAVE",
  "HAWK",
  "HAYS",
  "HEAD",
  "HEAL",
  "HEAR",
  "HEAT",
  "HEBE",
  "HECK",
  "HEED",
  "HEEL",
  "HEFT",
  "HELD",
  "HELL",
  "HELM",
  "HERB",
  "HERD",
  "HERE",
  "HERO",
  "HERS",
  "HESS",
  "HEWN",
  "HICK",
  "HIDE",
  "HIGH",
  "HIKE",
  "HILL",
  "HILT",
  "HIND",
  "HINT",
  "HIRE",
  "HISS",
  "HIVE",
  "HOBO",
  "HOCK",
  "HOFF",
  "HOLD",
  "HOLE",
  "HOLM",
  "HOLT",
  "HOME",
  "HONE",
  "HONK",
  "HOOD",
  "HOOF",
  "HOOK",
  "HOOT",
  "HORN",
  "HOSE",
  "HOST",
  "HOUR",
  "HOVE",
  "HOWE",
  "HOWL",
  "HOYT",
  "HUCK",
  "HUED",
  "HUFF",
  "HUGE",
  "HUGH",
  "HUGO",
  "HULK",
  "HULL",
  "HUNK",
  "HUNT",
  "HURD",
  "HURL",
  "HURT",
  "HUSH",
  "HYDE",
  "HYMN",
  "IBIS",
  "ICON",
  "IDEA",
  "IDLE",
  "IFFY",
  "INCA",
  "INCH",
  "INTO",
  "IONS",
  "IOTA",
  "IOWA",
  "IRIS",
  "IRMA",
  "IRON",
  "ISLE",
  "ITCH",
  "ITEM",
  "IVAN",
  "JACK",
  "JADE",
  "JAIL",
  "JAKE",
  "JANE",
  "JAVA",
  "JEAN",
  "JEFF",
  "JERK",
  "JESS",
  "JEST",
  "JIBE",
  "JILL",
  "JILT",
  "JIVE",
  "JOAN",
  "JOBS",
  "JOCK",
  "JOEL",
  "JOEY",
  "JOHN",
  "JOIN",
  "JOKE",
  "JOLT",
  "JOVE",
  "JUDD",
  "JUDE",
  "JUDO",
  "JUDY",
  "JUJU",
  "JUKE",
  "JULY",
  "JUNE",
  "JUNK",
  "JUNO",
  "JURY",
  "JUST",
  "JUTE",
  "KAHN",
  "KALE",
  "KANE",
  "KANT",
  "KARL",
  "KATE",
  "KEEL",
  "KEEN",
  "KENO",
  "KENT",
  "KERN",
  "KERR",
  "KEYS",
  "KICK",
  "KILL",
  "KIND",
  "KING",
  "KIRK",
  "KISS",
  "KITE",
  "KLAN",
  "KNEE",
  "KNEW",
  "KNIT",
  "KNOB",
  "KNOT",
  "KNOW",
  "KOCH",
  "KONG",
  "KUDO",
  "KURD",
  "KURT",
  "KYLE",
  "LACE",
  "LACK",
  "LACY",
  "LADY",
  "LAID",
  "LAIN",
  "LAIR",
  "LAKE",
  "LAMB",
  "LAME",
  "LAND",
  "LANE",
  "LANG",
  "LARD",
  "LARK",
  "LASS",
  "LAST",
  "LATE",
  "LAUD",
  "LAVA",
  "LAWN",
  "LAWS",
  "LAYS",
  "LEAD",
  "LEAF",
  "LEAK",
  "LEAN",
  "LEAR",
  "LEEK",
  "LEER",
  "LEFT",
  "LEND",
  "LENS",
  "LENT",
  "LEON",
  "LESK",
  "LESS",
  "LEST",
  "LETS",
  "LIAR",
  "LICE",
  "LICK",
  "LIED",
  "LIEN",
  "LIES",
  "LIEU",
  "LIFE",
  "LIFT",
  "LIKE",
  "LILA",
  "LILT",
  "LILY",
  "LIMA",
  "LIMB",
  "LIME",
  "LIND",
  "LINE",
  "LINK",
  "LINT",
  "LION",
  "LISA",
  "LIST",
  "LIVE",
  "LOAD",
  "LOAF",
  "LOAM",
  "LOAN",
  "LOCK",
  "LOFT",
  "LOGE",
  "LOIS",
  "LOLA",
  "LONE",
  "LONG",
  "LOOK",
  "LOON",
  "LOOT",
  "LORD",
  "LORE",
  "LOSE",
  "LOSS",
  "LOST",
  "LOUD",
  "LOVE",
  "LOWE",
  "LUCK",
  "LUCY",
  "LUGE",
  "LUKE",
  "LULU",
  "LUND",
  "LUNG",
  "LURA",
  "LURE",
  "LURK",
  "LUSH",
  "LUST",
  "LYLE",
  "LYNN",
  "LYON",
  "LYRA",
  "MACE",
  "MADE",
  "MAGI",
  "MAID",
  "MAIL",
  "MAIN",
  "MAKE",
  "MALE",
  "MALI",
  "MALL",
  "MALT",
  "MANA",
  "MANN",
  "MANY",
  "MARC",
  "MARE",
  "MARK",
  "MARS",
  "MART",
  "MARY",
  "MASH",
  "MASK",
  "MASS",
  "MAST",
  "MATE",
  "MATH",
  "MAUL",
  "MAYO",
  "MEAD",
  "MEAL",
  "MEAN",
  "MEAT",
  "MEEK",
  "MEET",
  "MELD",
  "MELT",
  "MEMO",
  "MEND",
  "MENU",
  "MERT",
  "MESH",
  "MESS",
  "MICE",
  "MIKE",
  "MILD",
  "MILE",
  "MILK",
  "MILL",
  "MILT",
  "MIMI",
  "MIND",
  "MINE",
  "MINI",
  "MINK",
  "MINT",
  "MIRE",
  "MISS",
  "MIST",
  "MITE",
  "MITT",
  "MOAN",
  "MOAT",
  "MOCK",
  "MODE",
  "MOLD",
  "MOLE",
  "MOLL",
  "MOLT",
  "MONA",
  "MONK",
  "MONT",
  "MOOD",
  "MOON",
  "MOOR",
  "MOOT",
  "MORE",
  "MORN",
  "MORT",
  "MOSS",
  "MOST",
  "MOTH",
  "MOVE",
  "MUCH",
  "MUCK",
  "MUDD",
  "MUFF",
  "MULE",
  "MULL",
  "MURK",
  "MUSH",
  "MUST",
  "MUTE",
  "MUTT",
  "MYRA",
  "MYTH",
  "NAGY",
  "NAIL",
  "NAIR",
  "NAME",
  "NARY",
  "NASH",
  "NAVE",
  "NAVY",
  "NEAL",
  "NEAR",
  "NEAT",
  "NECK",
  "NEED",
  "NEIL",
  "NELL",
  "NEON",
  "NERO",
  "NESS",
  "NEST",
  "NEWS",
  "NEWT",
  "NIBS",
  "NICE",
  "NICK",
  "NILE",
  "NINA",
  "NINE",
  "NOAH",
  "NODE",
  "NOEL",
  "NOLL",
  "NONE",
  "NOOK",
  "NOON",
  "NORM",
  "NOSE",
  "NOTE",
  "NOUN",
  "NOVA",
  "NUDE",
  "NULL",
  "NUMB",
  "OATH",
  "OBEY",
  "OBOE",
  "ODIN",
  "OHIO",
  "OILY",
  "OINT",
  "OKAY",
  "OLAF",
  "OLDY",
  "OLGA",
  "OLIN",
  "OMAN",
  "OMEN",
  "OMIT",
  "ONCE",
  "ONES",
  "ONLY",
  "ONTO",
  "ONUS",
  "ORAL",
  "ORGY",
  "OSLO",
  "OTIS",
  "OTTO",
  "OUCH",
  "OUST",
  "OUTS",
  "OVAL",
  "OVEN",
  "OVER",
  "OWLY",
  "OWNS",
  "QUAD",
  "QUIT",
  "QUOD",
  "RACE",
  "RACK",
  "RACY",
  "RAFT",
  "RAGE",
  "RAID",
  "RAIL",
  "RAIN",
  "RAKE",
  "RANK",
  "RANT",
  "RARE",
  "RASH",
  "RATE",
  "RAVE",
  "RAYS",
  "READ",
  "REAL",
  "REAM",
  "REAR",
  "RECK",
  "REED",
  "REEF",
  "REEK",
  "REEL",
  "REID",
  "REIN",
  "RENA",
  "REND",
  "RENT",
  "REST",
  "RICE",
  "RICH",
  "RICK",
  "RIDE",
  "RIFT",
  "RILL",
  "RIME",
  "RING",
  "RINK",
  "RISE",
  "RISK",
  "RITE",
  "ROAD",
  "ROAM",
  "ROAR",
  "ROBE",
  "ROCK",
  "RODE",
  "ROIL",
  "ROLL",
  "ROME",
  "ROOD",
  "ROOF",
  "ROOK",
  "ROOM",
  "ROOT",
  "ROSA",
  "ROSE",
  "ROSS",
  "ROSY",
  "ROTH",
  "ROUT",
  "ROVE",
  "ROWE",
  "ROWS",
  "RUBE",
  "RUBY",
  "RUDE",
  "RUDY",
  "RUIN",
  "RULE",
  "RUNG",
  "RUNS",
  "RUNT",
  "RUSE",
  "RUSH",
  "RUSK",
  "RUSS",
  "RUST",
  "RUTH",
  "SACK",
  "SAFE",
  "SAGE",
  "SAID",
  "SAIL",
  "SALE",
  "SALK",
  "SALT",
  "SAME",
  "SAND",
  "SANE",
  "SANG",
  "SANK",
  "SARA",
  "SAUL",
  "SAVE",
  "SAYS",
  "SCAN",
  "SCAR",
  "SCAT",
  "SCOT",
  "SEAL",
  "SEAM",
  "SEAR",
  "SEAT",
  "SEED",
  "SEEK",
  "SEEM",
  "SEEN",
  "SEES",
  "SELF",
  "SELL",
  "SEND",
  "SENT",
  "SETS",
  "SEWN",
  "SHAG",
  "SHAM",
  "SHAW",
  "SHAY",
  "SHED",
  "SHIM",
  "SHIN",
  "SHOD",
  "SHOE",
  "SHOT",
  "SHOW",
  "SHUN",
  "SHUT",
  "SICK",
  "SIDE",
  "SIFT",
  "SIGH",
  "SIGN",
  "SILK",
  "SILL",
  "SILO",
  "SILT",
  "SINE",
  "SING",
  "SINK",
  "SIRE",
  "SITE",
  "SITS",
  "SITU",
  "SKAT",
  "SKEW",
  "SKID",
  "SKIM",
  "SKIN",
  "SKIT",
  "SLAB",
  "SLAM",
  "SLAT",
  "SLAY",
  "SLED",
  "SLEW",
  "SLID",
  "SLIM",
  "SLIT",
  "SLOB",
  "SLOG",
  "SLOT",
  "SLOW",
  "SLUG",
  "SLUM",
  "SLUR",
  "SMOG",
  "SMUG",
  "SNAG",
  "SNOB",
  "SNOW",
  "SNUB",
  "SNUG",
  "SOAK",
  "SOAR",
  "SOCK",
  "SODA",
  "SOFA",
  "SOFT",
  "SOIL",
  "SOLD",
  "SOME",
  "SONG",
  "SOON",
  "SOOT",
  "SORE",
  "SORT",
  "SOUL",
  "SOUR",
  "SOWN",
  "STAB",
  "STAG",
  "STAN",
  "STAR",
  "STAY",
  "STEM",
  "STEW",
  "STIR",
  "STOW",
  "STUB",
  "STUN",
  "SUCH",
  "SUDS",
  "SUIT",
  "SULK",
  "SUMS",
  "SUNG",
  "SUNK",
  "SURE",
  "SURF",
  "SWAB",
  "SWAG",
  "SWAM",
  "SWAN",
  "SWAT",
  "SWAY",
  "SWIM",
  "SWUM",
  "TACK",
  "TACT",
  "TAIL",
  "TAKE",
  "TALE",
  "TALK",
  "TALL",
  "TANK",
  "TASK",
  "TATE",
  "TAUT",
  "TEAL",
  "TEAM",
  "TEAR",
  "TECH",
  "TEEM",
  "TEEN",
  "TEET",
  "TELL",
  "TEND",
  "TENT",
  "TERM",
  "TERN",
  "TESS",
  "TEST",
  "THAN",
  "THAT",
  "THEE",
  "THEM",
  "THEN",
  "THEY",
  "THIN",
  "THIS",
  "THUD",
  "THUG",
  "TICK",
  "TIDE",
  "TIDY",
  "TIED",
  "TIER",
  "TILE",
  "TILL",
  "TILT",
  "TIME",
  "TINA",
  "TINE",
  "TINT",
  "TINY",
  "TIRE",
  "TOAD",
  "TOGO",
  "TOIL",
  "TOLD",
  "TOLL",
  "TONE",
  "TONG",
  "TONY",
  "TOOK",
  "TOOL",
  "TOOT",
  "TORE",
  "TORN",
  "TOTE",
  "TOUR",
  "TOUT",
  "TOWN",
  "TRAG",
  "TRAM",
  "TRAY",
  "TREE",
  "TREK",
  "TRIG",
  "TRIM",
  "TRIO",
  "TROD",
  "TROT",
  "TROY",
  "TRUE",
  "TUBA",
  "TUBE",
  "TUCK",
  "TUFT",
  "TUNA",
  "TUNE",
  "TUNG",
  "TURF",
  "TURN",
  "TUSK",
  "TWIG",
  "TWIN",
  "TWIT",
  "ULAN",
  "UNIT",
  "URGE",
  "USED",
  "USER",
  "USES",
  "UTAH",
  "VAIL",
  "VAIN",
  "VALE",
  "VARY",
  "VASE",
  "VAST",
  "VEAL",
  "VEDA",
  "VEIL",
  "VEIN",
  "VEND",
  "VENT",
  "VERB",
  "VERY",
  "VETO",
  "VICE",
  "VIEW",
  "VINE",
  "VISE",
  "VOID",
  "VOLT",
  "VOTE",
  "WACK",
  "WADE",
  "WAGE",
  "WAIL",
  "WAIT",
  "WAKE",
  "WALE",
  "WALK",
  "WALL",
  "WALT",
  "WAND",
  "WANE",
  "WANG",
  "WANT",
  "WARD",
  "WARM",
  "WARN",
  "WART",
  "WASH",
  "WAST",
  "WATS",
  "WATT",
  "WAVE",
  "WAVY",
  "WAYS",
  "WEAK",
  "WEAL",
  "WEAN",
  "WEAR",
  "WEED",
  "WEEK",
  "WEIR",
  "WELD",
  "WELL",
  "WELT",
  "WENT",
  "WERE",
  "WERT",
  "WEST",
  "WHAM",
  "WHAT",
  "WHEE",
  "WHEN",
  "WHET",
  "WHOA",
  "WHOM",
  "WICK",
  "WIFE",
  "WILD",
  "WILL",
  "WIND",
  "WINE",
  "WING",
  "WINK",
  "WINO",
  "WIRE",
  "WISE",
  "WISH",
  "WITH",
  "WOLF",
  "WONT",
  "WOOD",
  "WOOL",
  "WORD",
  "WORE",
  "WORK",
  "WORM",
  "WORN",
  "WOVE",
  "WRIT",
  "WYNN",
  "YALE",
  "YANG",
  "YANK",
  "YARD",
  "YARN",
  "YAWL",
  "YAWN",
  "YEAH",
  "YEAR",
  "YELL",
  "YOGA",
  "YOKE"
};

char *otpbtoe(char *c, char *engout)
{
  char cp[9];	/* add in room for the parity 2 bits */
  short p, i;

  engout[0] = '\0';
  memcpy(cp, c, 8);
  /* compute parity */
  for (p = 0, i = 0; i < 64; i += 2)
    p += otpextract(cp, i, 2);

  cp[8] = (char)(p << 6);
  strncat(engout, otpenglish[otpextract(cp, 0, 11)], 4);
  strcat(engout, " ");
  strncat(engout, otpenglish[otpextract(cp, 11, 11)], 4);
  strcat(engout, " ");
  strncat(engout, otpenglish[otpextract(cp, 22, 11)], 4);
  strcat(engout, " ");
  strncat(engout, otpenglish[otpextract(cp, 33, 11)], 4);
  strcat(engout, " ");
  strncat(engout, otpenglish[otpextract(cp, 44, 11)], 4);
  strcat(engout, " ");
  strncat(engout, otpenglish[otpextract(cp, 55, 11)], 4);
  return (engout);
}

unsigned long otpextract(char *s, short start, short length)
{
  unsigned long x;
  unsigned char cl;
  unsigned char cc;
  unsigned char cr;

  cl = s[start / 8];
  cc = s[start / 8 + 1];
  cr = s[start / 8 + 2];
  x = ((unsigned long) (cl << 8 | cc) << 8 | cr);
  x = x >> (24 - (length + (start % 8)));
  x = (x & (0xffff >> (16 - length)));
  return (x);
}
