/*
CLASS:lshd_connection_config:server_config
*/
#ifndef GABA_DEFINE
struct lshd_connection_config
{
  struct server_config super;
  int helper_fd;
};
extern struct lsh_class lshd_connection_config_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class lshd_connection_config_class =
{
  STATIC_HEADER,
  &(server_config_class),
  "lshd_connection_config",
  sizeof(struct lshd_connection_config),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:connection:ssh_connection
*/
#ifndef GABA_DEFINE
struct connection
{
  struct ssh_connection super;
  struct lshd_connection_config *config;
  struct service_read_state *reader;
};
extern struct lsh_class connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_connection_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct connection *i = (struct connection *) o;
  mark((struct lsh_object *) i->config);
  mark((struct lsh_object *) i->reader);
}
struct lsh_class connection_class =
{
  STATIC_HEADER,
  &(ssh_connection_class),
  "connection",
  sizeof(struct connection),
  do_connection_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

