#ifndef GABA_DEFINE
struct dh_client_exchange
{
  struct keyexchange_algorithm super;
  struct diffie_hellman_method *dh;
  struct alist *verifiers;
};
extern struct lsh_class dh_client_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_client_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_client_exchange *i = (struct dh_client_exchange *) o;
  mark((struct lsh_object *) i->dh);
  mark((struct lsh_object *) i->verifiers);
}

struct lsh_class dh_client_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "dh_client_exchange", sizeof(struct dh_client_exchange),
  do_dh_client_exchange_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dh_client
{
  struct packet_handler super;
  struct diffie_hellman_instance dh;
  UINT32 hostkey_algorithm;
  struct lookup_verifier *verifier;
  struct install_keys *install;
};
extern struct lsh_class dh_client_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_client_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_client *i = (struct dh_client *) o;
  diffie_hellman_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->verifier);
  mark((struct lsh_object *) i->install);
}

static void do_dh_client_free(struct lsh_object *o)
{
  struct dh_client *i = (struct dh_client *) o;
  diffie_hellman_instance_free(&i->dh);
}

struct lsh_class dh_client_class =
{ STATIC_HEADER,
  &packet_handler_class, "dh_client", sizeof(struct dh_client),
  do_dh_client_mark,
  do_dh_client_free
};
#endif /* !GABA_DECLARE */

