#ifndef GABA_DEFINE
struct connection_close_handler
{
  struct close_callback super;
  struct ssh_connection *connection;
};
extern struct lsh_class connection_close_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connection_close_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_close_handler *i = (struct connection_close_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class connection_close_handler_class =
{ STATIC_HEADER,
  &close_callback_class, "connection_close_handler", sizeof(struct connection_close_handler),
  do_connection_close_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connection_line_handler
{
  struct line_handler super;
  struct ssh_connection *connection;
  int mode;
  int fd;
  struct ssh1_fallback *fallback;
};
extern struct lsh_class connection_line_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connection_line_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_line_handler *i = (struct connection_line_handler *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->fallback);
}

struct lsh_class connection_line_handler_class =
{ STATIC_HEADER,
  &line_handler_class, "connection_line_handler", sizeof(struct connection_line_handler),
  do_connection_line_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connection_command
{
  struct command super;
  int mode;
  UINT32 block_size;
  const char * id_comment;
  struct randomness *random;
  struct alist *algorithms;
  struct make_kexinit *init;
  struct ssh1_fallback *fallback;
};
extern struct lsh_class connection_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connection_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_command *i = (struct connection_command *) o;
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->fallback);
}

struct lsh_class connection_command_class =
{ STATIC_HEADER,
  &command_class, "connection_command", sizeof(struct connection_command),
  do_connection_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connection_remember_command
{
  struct command super;
  struct ssh_connection *connection;
};
extern struct lsh_class connection_remember_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connection_remember_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_remember_command *i = (struct connection_remember_command *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class connection_remember_command_class =
{ STATIC_HEADER,
  &command_class, "connection_remember_command", sizeof(struct connection_remember_command),
  do_connection_remember_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

