/* proxy.h
 *
 * $Id$ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1999 Balazs Scheidler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef LSH_PROXY_H_INCLUDED

#include "lsh.h"
#include "command.h"
#include "connection.h"

#define GABA_DECLARE
#include "proxy.h.x"
#undef GABA_DECLARE

/* GABA:
   (class
     (name proxy_connection)
     (vars
       (client object ssh_connection)
       (server object ssh_connection)
       (set_client_conn method void "struct ssh_connection *conn")
       (set_server_conn method void "struct ssh_connection *conn")))
*/

#define SET_CLIENT_CONN(p, c) ((p)->set_client_conn(p, c))
#define SET_SERVER_CONN(p, s) ((p)->set_server_conn(p, s))

struct command *make_notify_server_conn(struct proxy_connection *proxy);
struct command *make_notify_client_conn(struct proxy_connection *proxy);

struct proxy_connection *make_proxy_connection(void);

extern struct command_simple get_trans_proxy_dest;

#endif
