#ifndef GABA_DEFINE
struct listen_command_callback
{
  struct fd_listen_callback super;
  struct io_backend *backend;
  struct command_continuation *c;
};
extern struct lsh_class listen_command_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_command_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_command_callback *i = (struct listen_command_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->c);
}

struct lsh_class listen_command_callback_class =
{ STATIC_HEADER,
  &fd_listen_callback_class, "listen_command_callback", sizeof(struct listen_command_callback),
  do_listen_command_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_connection
{
  struct command super;
  struct io_backend *backend;
  struct ssh_connection *connection;
};
extern struct lsh_class listen_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_connection *i = (struct listen_connection *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->connection);
}

struct lsh_class listen_connection_class =
{ STATIC_HEADER,
  &command_class, "listen_connection", sizeof(struct listen_connection),
  do_listen_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_command_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  struct command_continuation *c;
};
extern struct lsh_class connect_command_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_command_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_command_callback *i = (struct connect_command_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->c);
}

struct lsh_class connect_command_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "connect_command_callback", sizeof(struct connect_command_callback),
  do_connect_command_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct simple_io_command
{
  struct command super;
  struct io_backend *backend;
  struct resource_list *resources;
};
extern struct lsh_class simple_io_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_simple_io_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct simple_io_command *i = (struct simple_io_command *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->resources);
}

struct lsh_class simple_io_command_class =
{ STATIC_HEADER,
  &command_class, "simple_io_command", sizeof(struct simple_io_command),
  do_simple_io_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

