#ifndef GABA_DEFINE
struct keypair
{
  struct lsh_object super;
  int type;
  struct lsh_string *public;
  struct signer *private;
};
extern struct lsh_class keypair_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_keypair_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct keypair *i = (struct keypair *) o;
  mark((struct lsh_object *) i->private);
}

static void do_keypair_free(struct lsh_object *o)
{
  struct keypair *i = (struct keypair *) o;
  lsh_string_free(i->public);
}

struct lsh_class keypair_class =
{ STATIC_HEADER,
  0, "keypair", sizeof(struct keypair),
  do_keypair_mark,
  do_keypair_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dsa_public
{
  mpz_t p;
  mpz_t q;
  mpz_t g;
  mpz_t y;
};
extern void dsa_public_mark(struct dsa_public *i, 
    void (*mark)(struct lsh_object *o));
extern void dsa_public_free(struct dsa_public *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void dsa_public_mark(struct dsa_public *i, 
    void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
}

void dsa_public_free(struct dsa_public *i)
{
  (void) i;
  mpz_clear(i->p);
  mpz_clear(i->q);
  mpz_clear(i->g);
  mpz_clear(i->y);
}

#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dsa_signer
{
  struct signer super;
  struct randomness *random;
  struct dsa_public public;
  mpz_t a;
};
extern struct lsh_class dsa_signer_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dsa_signer_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  mark((struct lsh_object *) i->random);
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_signer_free(struct lsh_object *o)
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  dsa_public_free(&i->public);
  mpz_clear(i->a);
}

struct lsh_class dsa_signer_class =
{ STATIC_HEADER,
  &signer_class, "dsa_signer", sizeof(struct dsa_signer),
  do_dsa_signer_mark,
  do_dsa_signer_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dsa_verifier
{
  struct verifier super;
  struct dsa_public public;
};
extern struct lsh_class dsa_verifier_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dsa_verifier_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_verifier_free(struct lsh_object *o)
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_free(&i->public);
}

struct lsh_class dsa_verifier_class =
{ STATIC_HEADER,
  &verifier_class, "dsa_verifier", sizeof(struct dsa_verifier),
  do_dsa_verifier_mark,
  do_dsa_verifier_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct group
{
  struct lsh_object super;
  mpz_t order;
  int (*(member))(struct group *self, mpz_t x);
  void (*(invert))(struct group *self, mpz_t res, mpz_t x);
  void (*(combine))(struct group *self, mpz_t res, mpz_t a, mpz_t b);
  void (*(power))(struct group *self, mpz_t res, mpz_t g, mpz_t e);
};
extern struct lsh_class group_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_group_free(struct lsh_object *o)
{
  struct group *i = (struct group *) o;
  mpz_clear(i->order);
}

struct lsh_class group_class =
{ STATIC_HEADER,
  0, "group", sizeof(struct group),
  NULL,
  do_group_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct diffie_hellman_method
{
  struct lsh_object super;
  struct group *G;
  mpz_t generator;
  struct hash_algorithm *H;
  struct randomness *random;
};
extern struct lsh_class diffie_hellman_method_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_diffie_hellman_method_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct diffie_hellman_method *i = (struct diffie_hellman_method *) o;
  mark((struct lsh_object *) i->G);
  mark((struct lsh_object *) i->H);
  mark((struct lsh_object *) i->random);
}

static void do_diffie_hellman_method_free(struct lsh_object *o)
{
  struct diffie_hellman_method *i = (struct diffie_hellman_method *) o;
  mpz_clear(i->generator);
}

struct lsh_class diffie_hellman_method_class =
{ STATIC_HEADER,
  0, "diffie_hellman_method", sizeof(struct diffie_hellman_method),
  do_diffie_hellman_method_mark,
  do_diffie_hellman_method_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct diffie_hellman_instance
{
  struct diffie_hellman_method *method;
  mpz_t e;
  mpz_t f;
  struct lsh_string *server_key;
  struct lsh_string *signature;
  mpz_t secret;
  mpz_t K;
  struct hash_instance *hash;
  struct lsh_string *exchange_hash;
};
extern void diffie_hellman_instance_mark(struct diffie_hellman_instance *i, 
    void (*mark)(struct lsh_object *o));
extern void diffie_hellman_instance_free(struct diffie_hellman_instance *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void diffie_hellman_instance_mark(struct diffie_hellman_instance *i, 
    void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
  mark((struct lsh_object *) i->method);
  mark((struct lsh_object *) i->hash);
}

void diffie_hellman_instance_free(struct diffie_hellman_instance *i)
{
  (void) i;
  mpz_clear(i->e);
  mpz_clear(i->f);
  lsh_string_free(i->server_key);
  lsh_string_free(i->signature);
  mpz_clear(i->secret);
  mpz_clear(i->K);
  lsh_string_free(i->exchange_hash);
}

#endif /* !GABA_DECLARE */

