#ifndef GABA_DEFINE
struct chain_connections_continuation
{
  struct command_frame super;
  struct ssh_connection *connection;
};
extern struct lsh_class chain_connections_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_chain_connections_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct chain_connections_continuation *i = (struct chain_connections_continuation *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class chain_connections_continuation_class =
{ STATIC_HEADER,
  &command_frame_class, "chain_connections_continuation", sizeof(struct chain_connections_continuation),
  do_chain_connections_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct chain_connections
{
  struct command super;
  struct command *callback;
  struct listen_value *lv;
};
extern struct lsh_class chain_connections_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_chain_connections_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct chain_connections *i = (struct chain_connections *) o;
  mark((struct lsh_object *) i->callback);
  mark((struct lsh_object *) i->lv);
}

struct lsh_class chain_connections_class =
{ STATIC_HEADER,
  &command_class, "chain_connections", sizeof(struct chain_connections),
  do_chain_connections_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_connection_service
{
  struct command super;
  struct alist *server_requests;
  struct alist *client_requests;
};
extern struct lsh_class proxy_connection_service_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_connection_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_connection_service *i = (struct proxy_connection_service *) o;
  mark((struct lsh_object *) i->server_requests);
  mark((struct lsh_object *) i->client_requests);
}

struct lsh_class proxy_connection_service_class =
{ STATIC_HEADER,
  &command_class, "proxy_connection_service", sizeof(struct proxy_connection_service),
  do_proxy_connection_service_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_accept_service_handler
{
  struct packet_handler super;
  UINT32 name;
  struct command *service;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class proxy_accept_service_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_accept_service_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_accept_service_handler *i = (struct proxy_accept_service_handler *) o;
  mark((struct lsh_object *) i->service);
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class proxy_accept_service_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "proxy_accept_service_handler", sizeof(struct proxy_accept_service_handler),
  do_proxy_accept_service_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_service_handler
{
  struct packet_handler super;
  struct alist *services;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class proxy_service_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_service_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_service_handler *i = (struct proxy_service_handler *) o;
  mark((struct lsh_object *) i->services);
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class proxy_service_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "proxy_service_handler", sizeof(struct proxy_service_handler),
  do_proxy_service_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_offer_service
{
  struct command super;
  struct alist *services;
};
extern struct lsh_class proxy_offer_service_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_offer_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_offer_service *i = (struct proxy_offer_service *) o;
  mark((struct lsh_object *) i->services);
}

struct lsh_class proxy_offer_service_class =
{ STATIC_HEADER,
  &command_class, "proxy_offer_service", sizeof(struct proxy_offer_service),
  do_proxy_offer_service_mark,
  NULL
};
#endif /* !GABA_DECLARE */

