#ifndef GABA_DEFINE
struct general_channel_request_command
{
  struct channel_request_command super;
  struct lsh_string *request;
};
extern struct lsh_class general_channel_request_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_general_channel_request_command_free(struct lsh_object *o)
{
  struct general_channel_request_command *i = (struct general_channel_request_command *) o;
  lsh_string_free(i->request);
}

struct lsh_class general_channel_request_command_class =
{ STATIC_HEADER,
  &channel_request_command_class, "general_channel_request_command", sizeof(struct general_channel_request_command),
  NULL,
  do_general_channel_request_command_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct general_global_request_command
{
  struct global_request_command super;
  struct lsh_string *request;
};
extern struct lsh_class general_global_request_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_general_global_request_command_free(struct lsh_object *o)
{
  struct general_global_request_command *i = (struct general_global_request_command *) o;
  lsh_string_free(i->request);
}

struct lsh_class general_global_request_command_class =
{ STATIC_HEADER,
  &global_request_command_class, "general_global_request_command", sizeof(struct general_global_request_command),
  NULL,
  do_general_global_request_command_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_channel_open_continuation
{
  struct command_continuation super;
  struct command_continuation *up;
  struct proxy_channel *channel;
};
extern struct lsh_class proxy_channel_open_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_open_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel_open_continuation *i = (struct proxy_channel_open_continuation *) o;
  mark((struct lsh_object *) i->up);
  mark((struct lsh_object *) i->channel);
}

struct lsh_class proxy_channel_open_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "proxy_channel_open_continuation", sizeof(struct proxy_channel_open_continuation),
  do_proxy_channel_open_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_channel_open_command
{
  struct channel_open_command super;
  UINT32 type;
  struct alist *requests;
  struct lsh_string *open_request;
};
extern struct lsh_class proxy_channel_open_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_open_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel_open_command *i = (struct proxy_channel_open_command *) o;
  mark((struct lsh_object *) i->requests);
}

static void do_proxy_channel_open_command_free(struct lsh_object *o)
{
  struct proxy_channel_open_command *i = (struct proxy_channel_open_command *) o;
  lsh_string_free(i->open_request);
}

struct lsh_class proxy_channel_open_command_class =
{ STATIC_HEADER,
  &channel_open_command_class, "proxy_channel_open_command", sizeof(struct proxy_channel_open_command),
  do_proxy_channel_open_command_mark,
  do_proxy_channel_open_command_free
};
#endif /* !GABA_DECLARE */

